/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.datum;

import java.util.Collections;
import java.util.Map;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.datum.AbstractDatum;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.resources.Utilities;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PixelInCell;

public class DefaultImageDatum
extends AbstractDatum
implements ImageDatum {
    private static final long serialVersionUID = -4304193511244150936L;
    private final PixelInCell pixelInCell;

    public DefaultImageDatum(ImageDatum datum) {
        super(datum);
        this.pixelInCell = datum.getPixelInCell();
    }

    public DefaultImageDatum(String name, PixelInCell pixelInCell) {
        this(Collections.singletonMap("name", name), pixelInCell);
    }

    public DefaultImageDatum(Map properties, PixelInCell pixelInCell) {
        super(properties);
        this.pixelInCell = pixelInCell;
        DefaultImageDatum.ensureNonNull("pixelInCell", pixelInCell);
    }

    public PixelInCell getPixelInCell() {
        return this.pixelInCell;
    }

    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareMetadata)) {
            DefaultImageDatum that = (DefaultImageDatum)object;
            return Utilities.equals(this.pixelInCell, that.pixelInCell);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() ^ this.pixelInCell.hashCode();
    }

    protected String formatWKT(Formatter formatter) {
        super.formatWKT(formatter);
        formatter.append(this.pixelInCell);
        formatter.setInvalidWKT();
        return "IMAGE_DATUM";
    }
}

