/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.cs;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.cs.DefaultCompoundCS;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotools.referencing.cs.DefaultEllipsoidalCS;
import org.geotools.referencing.cs.DefaultSphericalCS;
import org.geotools.referencing.cs.DefaultTimeCS;
import org.geotools.referencing.cs.DefaultVerticalCS;
import org.geotools.resources.i18n.Errors;
import org.opengis.referencing.cs.AffineCS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.LinearCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.UserDefinedCS;
import org.opengis.referencing.cs.VerticalCS;

final class PredefinedCS
implements Comparator {
    private static Comparator csComparator;
    private final Class[] types = new Class[]{CartesianCS.class, AffineCS.class, EllipsoidalCS.class, SphericalCS.class, CylindricalCS.class, PolarCS.class, VerticalCS.class, TimeCS.class, LinearCS.class, UserDefinedCS.class};

    private PredefinedCS() {
    }

    public int compare(Object object1, Object object2) {
        Class<?> type1 = object1.getClass();
        Class<?> type2 = object2.getClass();
        for (int i = 0; i < this.types.length; ++i) {
            Class type = this.types[i];
            boolean a1 = type.isAssignableFrom(type1);
            boolean a2 = type.isAssignableFrom(type2);
            if (a1) {
                return a2 ? 0 : -1;
            }
            if (!a2) continue;
            return a1 ? 0 : 1;
        }
        return 0;
    }

    static CoordinateSystem standard(CoordinateSystem cs) throws IllegalArgumentException {
        int dimension = cs.getDimension();
        if (cs instanceof CartesianCS) {
            switch (dimension) {
                case 2: {
                    if (PredefinedCS.sameAxisNames(DefaultCartesianCS.PROJECTED, cs)) {
                        return DefaultCartesianCS.PROJECTED;
                    }
                    if (PredefinedCS.sameAxisNames(DefaultCartesianCS.GRID, cs)) {
                        return DefaultCartesianCS.GRID;
                    }
                    return DefaultCartesianCS.GENERIC_2D;
                }
                case 3: {
                    if (PredefinedCS.sameAxisNames(DefaultCartesianCS.GEOCENTRIC, cs)) {
                        return DefaultCartesianCS.GEOCENTRIC;
                    }
                    return DefaultCartesianCS.GENERIC_3D;
                }
            }
        }
        if (cs instanceof EllipsoidalCS) {
            switch (dimension) {
                case 2: {
                    return DefaultEllipsoidalCS.GEODETIC_2D;
                }
                case 3: {
                    return DefaultEllipsoidalCS.GEODETIC_3D;
                }
            }
        }
        if (cs instanceof SphericalCS) {
            switch (dimension) {
                case 3: {
                    return DefaultSphericalCS.GEOCENTRIC;
                }
            }
        }
        if (cs instanceof VerticalCS) {
            switch (dimension) {
                case 1: {
                    return DefaultVerticalCS.ELLIPSOIDAL_HEIGHT;
                }
            }
        }
        if (cs instanceof TimeCS) {
            switch (dimension) {
                case 1: {
                    return DefaultTimeCS.DAYS;
                }
            }
        }
        if (cs instanceof DefaultCompoundCS) {
            List components = ((DefaultCompoundCS)cs).getCoordinateSystems();
            Object[] user = new CoordinateSystem[components.size()];
            Object[] std = new CoordinateSystem[user.length];
            for (int i = 0; i < std.length; ++i) {
                user[i] = (CoordinateSystem)components.get(i);
                std[i] = PredefinedCS.standard((CoordinateSystem)user[i]);
            }
            if (csComparator == null) {
                csComparator = new PredefinedCS();
            }
            Arrays.sort(std, csComparator);
            return Arrays.equals(user, std) ? cs : new DefaultCompoundCS((CoordinateSystem[])std);
        }
        throw new IllegalArgumentException(Errors.format(151, cs.getName().getCode()));
    }

    private static boolean sameAxisNames(CoordinateSystem stdCS, CoordinateSystem userCS) {
        int i;
        String[] userNames = new String[userCS.getDimension()];
        for (i = 0; i < userNames.length; ++i) {
            userNames[i] = userCS.getAxis(i).getName().getCode().trim();
        }
        i = stdCS.getDimension();
        block1: while (--i >= 0) {
            CoordinateSystemAxis op;
            CoordinateSystemAxis axis = stdCS.getAxis(i);
            String name = axis.getName().getCode().trim();
            String opposite = null;
            if (axis instanceof DefaultCoordinateSystemAxis && (op = ((DefaultCoordinateSystemAxis)axis).getOpposite()) != null) {
                opposite = op.getName().getCode().trim();
            }
            int j = userNames.length;
            while (--j >= 0) {
                String userName = userNames[j];
                if (userName == null || !userName.equalsIgnoreCase(name) && (opposite == null || !userName.equalsIgnoreCase(opposite))) continue;
                userNames[j] = null;
                continue block1;
            }
            return false;
        }
        return true;
    }
}

