/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.crs;

import java.util.HashMap;
import java.util.Map;
import javax.units.Unit;
import org.geotools.measure.Measure;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.AbstractReferenceSystem;
import org.geotools.referencing.cs.AbstractCS;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.resources.CRSUtilities;
import org.geotools.resources.i18n.Vocabulary;
import org.geotools.util.UnsupportedImplementationException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.spatialschema.geometry.MismatchedDimensionException;
import org.opengis.util.InternationalString;

public abstract class AbstractCRS
extends AbstractReferenceSystem
implements CoordinateReferenceSystem {
    private static final long serialVersionUID = -7433284548909530047L;
    protected final CoordinateSystem coordinateSystem;

    public AbstractCRS(CoordinateReferenceSystem crs) {
        super(crs);
        this.coordinateSystem = crs.getCoordinateSystem();
    }

    public AbstractCRS(Map properties, CoordinateSystem cs) {
        super(properties);
        AbstractCRS.ensureNonNull("cs", cs);
        this.coordinateSystem = cs;
    }

    static Map name(int key) {
        HashMap<String, CharSequence> properties = new HashMap<String, CharSequence>(4);
        InternationalString name = Vocabulary.formatInternational(key);
        properties.put("name", ((Object)name).toString());
        properties.put("alias", name);
        return properties;
    }

    public CoordinateSystem getCoordinateSystem() {
        return this.coordinateSystem;
    }

    final Unit getUnit() {
        return CRSUtilities.getUnit(this.coordinateSystem);
    }

    public Measure distance(double[] coord1, double[] coord2) throws UnsupportedOperationException, MismatchedDimensionException {
        if (this.coordinateSystem instanceof AbstractCS) {
            return ((AbstractCS)this.coordinateSystem).distance(coord1, coord2);
        }
        throw new UnsupportedImplementationException(this.coordinateSystem.getClass());
    }

    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (super.equals(object, compareMetadata)) {
            AbstractCRS that = (AbstractCRS)object;
            return AbstractCRS.equals(this.coordinateSystem, that.coordinateSystem, compareMetadata);
        }
        return false;
    }

    public int hashCode() {
        return 0x3D90441 ^ this.coordinateSystem.hashCode();
    }

    protected String formatWKT(Formatter formatter) {
        Unit unit = this.getUnit();
        formatter.append(unit);
        int dimension = this.coordinateSystem.getDimension();
        for (int i = 0; i < dimension; ++i) {
            formatter.append(this.coordinateSystem.getAxis(i));
        }
        if (unit == null) {
            formatter.setInvalidWKT();
        }
        return super.formatWKT(formatter);
    }
}

