/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.parameter;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.ParameterList;
import javax.media.jai.ParameterListImpl;
import org.geotools.parameter.AbstractParameter;
import org.geotools.parameter.ImagingParameter;
import org.geotools.parameter.ImagingParameterDescriptors;
import org.geotools.parameter.Parameter;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.opengis.parameter.InvalidParameterNameException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;

public class ImagingParameters
extends AbstractParameter
implements ParameterValueGroup {
    private static final long serialVersionUID = 1378692626023992530L;
    public final ParameterList parameters;
    private transient List values;
    private transient List asList;

    public ImagingParameters(ImagingParameterDescriptors descriptor) {
        super(descriptor);
        this.parameters = descriptor.operation instanceof OperationDescriptor ? new ParameterBlockJAI((OperationDescriptor)descriptor.operation, descriptor.registryMode) : new ParameterListImpl(descriptor.descriptor);
    }

    public ImagingParameters(Map properties, ParameterList parameters) {
        super(new ImagingParameterDescriptors(properties, parameters.getParameterListDescriptor()));
        this.parameters = parameters;
        ImagingParameters.ensureNonNull("parameters", parameters);
    }

    private void createElements() {
        String name;
        ImagingParameterDescriptors descriptor = (ImagingParameterDescriptors)this.descriptor;
        List descriptors = descriptor.descriptors();
        Set parameterNames = descriptor.getParameterNames();
        this.values = new ArrayList(descriptors.size());
        Iterator it = descriptors.iterator();
        while (it.hasNext()) {
            ParameterDescriptor d = (ParameterDescriptor)it.next();
            name = d.getName().getCode().trim().toLowerCase();
            AbstractParameter value = parameterNames.contains(name) ? new ImagingParameter(d, this.parameters) : new Parameter(d);
            this.values.add(value);
        }
        int size = this.values.size();
        for (int j = 0; j < size; ++j) {
            name = ((ParameterValue)this.values.get(j)).getDescriptor().getName().getCode().trim();
            for (int i = 0; i < size; ++i) {
                ParameterDescriptor d;
                if (i == j || !AbstractIdentifiedObject.nameMatches(d = (ParameterDescriptor)((ParameterValue)this.values.get(i)).getDescriptor(), name)) continue;
                throw new InvalidParameterNameException(Errors.format(113, d.getName().getCode(), new Integer(j), name, new Integer(i)), name);
            }
        }
        this.asList = Collections.unmodifiableList(this.values);
    }

    public synchronized List values() {
        if (this.asList == null) {
            this.createElements();
        }
        return this.asList;
    }

    public synchronized ParameterValue parameter(String name) throws ParameterNotFoundException {
        ImagingParameters.ensureNonNull("name", name);
        name = name.trim();
        if (this.values == null) {
            this.createElements();
        }
        int size = this.values.size();
        for (int i = 0; i < size; ++i) {
            ParameterValue value = (ParameterValue)this.values.get(i);
            if (!AbstractIdentifiedObject.nameMatches(value.getDescriptor(), name)) continue;
            return value;
        }
        throw new ParameterNotFoundException(Errors.format(71, name), name);
    }

    public List groups(String name) throws ParameterNotFoundException {
        throw new ParameterNotFoundException(Errors.format(71, name), name);
    }

    public ParameterValueGroup addGroup(String name) throws ParameterNotFoundException, IllegalStateException {
        throw new ParameterNotFoundException(Errors.format(71, name), name);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            ImagingParameters that = (ImagingParameters)object;
            return Utilities.equals(this.parameters, that.parameters);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() * 37 + this.parameters.hashCode();
    }

    public Object clone() {
        ImagingParameters copy = (ImagingParameters)super.clone();
        try {
            Method cloneMethod = this.parameters.getClass().getMethod("clone", null);
            Field paramField = ImagingParameters.class.getField("parameters");
            paramField.setAccessible(true);
            paramField.set(copy, cloneMethod.invoke((Object)this.parameters, (Object[])null));
        }
        catch (Exception exception) {
            UnsupportedOperationException e = new UnsupportedOperationException("Clone not supported.");
            e.initCause(exception);
            throw e;
        }
        if (copy.values != null) {
            copy.createElements();
            int i = this.values.size();
            while (--i >= 0) {
                ParameterValue value = (ParameterValue)this.values.get(i);
                if (!(value instanceof Parameter)) continue;
                copy.values.set(i, (ParameterValue)value.clone());
            }
        }
        return copy;
    }
}

