/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.parameter;

import java.awt.image.RenderedImage;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.ParameterListDescriptor;
import javax.media.jai.RegistryElementDescriptor;
import javax.media.jai.util.Range;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.metadata.iso.citation.ContactImpl;
import org.geotools.metadata.iso.citation.OnLineResourceImpl;
import org.geotools.metadata.iso.citation.ResponsiblePartyImpl;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ImagingParameterDescription;
import org.geotools.parameter.ImagingParameters;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.resources.Utilities;
import org.geotools.util.NameFactory;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.OnLineFunction;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Role;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

public class ImagingParameterDescriptors
extends DefaultParameterDescriptorGroup {
    private static final long serialVersionUID = 2127050865911951239L;
    private static final Object[] AUTHORITIES = new Object[]{"com.sun.media.jai", Citations.JAI, "org.geotools", Citations.GEOTOOLS};
    public static final Map DEFAULT_SOURCE_TYPE_MAP = Collections.singletonMap(RenderedImage.class, GridCoverage.class);
    final String registryMode;
    protected final RegistryElementDescriptor operation;
    protected final ParameterListDescriptor descriptor;
    private transient Set parameterNames;
    static /* synthetic */ Class class$javax$media$jai$EnumeratedParameter;

    public ImagingParameterDescriptors(RegistryElementDescriptor operation) {
        this(ImagingParameterDescriptors.properties(operation), operation, DEFAULT_SOURCE_TYPE_MAP, "rendered");
    }

    public ImagingParameterDescriptors(Map properties, RegistryElementDescriptor operation, Map sourceTypeMap, String registryMode) {
        this(properties, operation.getParameterListDescriptor(registryMode), operation, sourceTypeMap, registryMode);
    }

    public ImagingParameterDescriptors(Map properties, ParameterListDescriptor descriptor) {
        this(properties, descriptor, null, null, null);
    }

    private ImagingParameterDescriptors(Map properties, ParameterListDescriptor descriptor, RegistryElementDescriptor operation, Map sourceTypeMap, String registryMode) {
        super(properties, 1, 1, ImagingParameterDescriptors.asDescriptors(descriptor, operation, sourceTypeMap, registryMode));
        this.descriptor = descriptor;
        this.operation = operation;
        this.registryMode = registryMode;
    }

    public static Map properties(RegistryElementDescriptor operation) {
        String name = operation.getName();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (operation instanceof OperationDescriptor) {
            OperationDescriptor op = (OperationDescriptor)operation;
            ResourceBundle bundle = op.getResourceBundle(Locale.getDefault());
            String vendor = op.getResourceBundle(Locale.US).getString("Vendor");
            Citation authority = null;
            if (vendor != null) {
                vendor = vendor.trim();
                name = ImagingParameterDescription.trimPrefix(name, vendor);
                for (int i = 0; i < AUTHORITIES.length; i += 2) {
                    if (!vendor.equalsIgnoreCase((String)AUTHORITIES[i])) continue;
                    authority = (Citation)AUTHORITIES[i + 1];
                    break;
                }
            }
            ImagingParameterDescription description = new ImagingParameterDescription(op, "Description", null);
            try {
                ResponsibleParty oldParty;
                URI uri = new URI(bundle.getString("DocURL"));
                OnLineResourceImpl resource = new OnLineResourceImpl(uri);
                resource.setFunction(OnLineFunction.INFORMATION);
                resource.setDescription(description);
                CitationImpl citation = new CitationImpl(authority);
                Collection parties = citation.getCitedResponsibleParties();
                Iterator it = parties.iterator();
                if (it.hasNext()) {
                    oldParty = (ResponsibleParty)it.next();
                    it.remove();
                } else {
                    oldParty = null;
                }
                ResponsiblePartyImpl party = new ResponsiblePartyImpl(oldParty);
                party.setRole(Role.RESOURCE_PROVIDER);
                party.setContactInfo(new ContactImpl(resource));
                parties.add(party);
                authority = (Citation)((Object)citation.unmodifiable());
            }
            catch (URISyntaxException exception) {
                // empty catch block
            }
            GenericName alias = NameFactory.create(new InternationalString[]{new ImagingParameterDescription(op, "Vendor", null), new ImagingParameterDescription(op, "LocalName", "Vendor")}, '.');
            properties.put("alias", alias);
            properties.put("remarks", description);
            properties.put("version", bundle.getString("Version"));
            properties.put("authority", authority);
        }
        properties.put("name", name);
        return properties;
    }

    private static ParameterDescriptor[] asDescriptors(ParameterListDescriptor descriptor, RegistryElementDescriptor operation, Map sourceTypeMap, String registryMode) {
        int i;
        ParameterDescriptor[] desc;
        int numSources;
        ImagingParameterDescriptors.ensureNonNull("descriptor", descriptor);
        HashMap<String, CharSequence> properties = new HashMap<String, CharSequence>();
        int numParameters = descriptor.getNumParameters();
        if (operation instanceof OperationDescriptor) {
            OperationDescriptor op = (OperationDescriptor)operation;
            String[] names = op.getSourceNames();
            Class[] types = op.getSourceClasses(registryMode);
            numSources = op.getNumSources();
            desc = new ParameterDescriptor[numParameters + numSources];
            for (i = 0; i < numSources; ++i) {
                char c;
                int length;
                Class type = (Class)sourceTypeMap.get(types[i]);
                if (type == null) {
                    type = types[i];
                }
                String name = names[i];
                properties.clear();
                if (numSources == 1 && (length = name.length()) != 0 && ((c = name.charAt(length - 1)) == '0' || c == '1')) {
                    properties.put("alias", name);
                    name = name.substring(0, length - 1);
                }
                properties.put("name", name);
                desc[i] = new DefaultParameterDescriptor(properties, type, null, null, null, null, null, true);
            }
        } else {
            numSources = 0;
            desc = new ParameterDescriptor[numParameters];
        }
        String[] names = descriptor.getParamNames();
        Class[] classes = descriptor.getParamClasses();
        Object[] defaults = descriptor.getParamDefaults();
        for (i = 0; i < numParameters; ++i) {
            ImagingParameterDescription remark;
            Object defaultValue;
            Object[] validValues;
            Comparable max;
            Comparable min;
            String name = names[i];
            Class type = classes[i];
            Range range = descriptor.getParamValueRange(name);
            if (range != null) {
                min = range.getMinValue();
                max = range.getMaxValue();
            } else {
                min = null;
                max = null;
            }
            if ((class$javax$media$jai$EnumeratedParameter == null ? ImagingParameterDescriptors.class$("javax.media.jai.EnumeratedParameter") : class$javax$media$jai$EnumeratedParameter).isAssignableFrom(type)) {
                try {
                    validValues = descriptor.getEnumeratedParameterValues(name);
                }
                catch (UnsupportedOperationException exception) {
                    validValues = null;
                }
            } else {
                validValues = null;
            }
            if ((defaultValue = defaults[i]) == ParameterListDescriptor.NO_PARAMETER_DEFAULT) {
                defaultValue = null;
            }
            properties.clear();
            properties.put("name", name);
            if (operation instanceof OperationDescriptor && (remark = new ImagingParameterDescription((OperationDescriptor)operation, i)).exists()) {
                properties.put("remarks", remark);
            }
            desc[i + numSources] = new DefaultParameterDescriptor(properties, type, validValues, defaultValue, min, max, null, true);
        }
        return desc;
    }

    final Set getParameterNames() {
        if (this.parameterNames == null) {
            String[] names = this.descriptor.getParamNames();
            if (names != null) {
                this.parameterNames = new HashSet((int)((float)names.length / 0.75f) + 1);
                for (int i = 0; i < names.length; ++i) {
                    this.parameterNames.add(names[i].trim().toLowerCase());
                }
                this.parameterNames = Collections.unmodifiableSet(this.parameterNames);
            } else {
                this.parameterNames = Collections.EMPTY_SET;
            }
        }
        return this.parameterNames;
    }

    public GeneralParameterValue createValue() {
        return new ImagingParameters(this);
    }

    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareMetadata)) {
            ImagingParameterDescriptors that = (ImagingParameterDescriptors)object;
            return Utilities.equals(this.operation, that.operation) && Utilities.equals(this.descriptor, that.descriptor);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() ^ this.descriptor.hashCode();
    }
}

