/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.sql;

import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;

final class MetadataResult {
    private final String tableName;
    private final PreparedStatement statement;
    private ResultSet results;
    private String identifier;

    public MetadataResult(Connection connection, String query, String tableName) throws SQLException {
        this.tableName = tableName;
        int index = query.indexOf(63);
        if (index < 0) {
            throw new SQLException("Invalid query");
        }
        StringBuffer buffer = new StringBuffer(query);
        buffer.replace(index, index + 1, tableName);
        this.statement = connection.prepareStatement(buffer.toString());
    }

    private ResultSet getResultSet(String identifier) throws SQLException {
        if (this.results != null) {
            if (this.identifier.equals(identifier)) {
                return this.results;
            }
            if (this.results.next()) {
                Logger.getLogger("org.geotools.metadata.sql").warning("Duplicate identifier: " + identifier);
            }
            this.results.close();
            this.results = null;
        }
        this.identifier = identifier;
        this.statement.setString(1, identifier);
        this.results = this.statement.executeQuery();
        if (!this.results.next()) {
            this.results.close();
            this.results = null;
            throw new SQLException("Metadata not found: \"" + identifier + "\" in table \"" + this.tableName + '\"');
        }
        return this.results;
    }

    public Object getObject(String identifier, String columnName) throws SQLException {
        return this.getResultSet(identifier).getObject(columnName);
    }

    public Object getArray(String identifier, String columnName) throws SQLException {
        Array array = this.getResultSet(identifier).getArray(columnName);
        return array != null ? array.getArray() : null;
    }

    public int getInt(String identifier, String columnName) throws SQLException {
        return this.getResultSet(identifier).getInt(columnName);
    }

    public String getString(String identifier, String columnName) throws SQLException {
        return this.getResultSet(identifier).getString(columnName);
    }

    public String getString(String code) throws SQLException {
        return this.getResultSet(code).getString(1);
    }

    public boolean wasNull() throws SQLException {
        return this.results.wasNull();
    }

    public void close() throws SQLException {
        if (this.results != null) {
            this.results.close();
            this.results = null;
        }
        this.statement.close();
    }
}

