/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.maintenance;

import java.util.Date;
import org.geotools.metadata.iso.MetadataEntity;
import org.geotools.resources.Utilities;
import org.opengis.metadata.maintenance.MaintenanceFrequency;
import org.opengis.metadata.maintenance.MaintenanceInformation;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.maintenance.ScopeDescription;
import org.opengis.util.InternationalString;

public class MaintenanceInformationImpl
extends MetadataEntity
implements MaintenanceInformation {
    private static final long serialVersionUID = -8268338804608896671L;
    private MaintenanceFrequency maintenanceAndUpdateFrequency;
    private long dateOfNextUpdate = Long.MIN_VALUE;
    private long userDefinedMaintenanceFrequency;
    private ScopeCode updateScope;
    private ScopeDescription updateScopeDescription;
    private InternationalString maintenanceNote;

    public MaintenanceInformationImpl() {
    }

    public MaintenanceInformationImpl(MaintenanceFrequency maintenanceAndUpdateFrequency) {
        this.setMaintenanceAndUpdateFrequency(maintenanceAndUpdateFrequency);
    }

    public MaintenanceFrequency getMaintenanceAndUpdateFrequency() {
        return this.maintenanceAndUpdateFrequency;
    }

    public synchronized void setMaintenanceAndUpdateFrequency(MaintenanceFrequency newValue) {
        this.checkWritePermission();
        this.maintenanceAndUpdateFrequency = newValue;
    }

    public synchronized Date getDateOfNextUpdate() {
        return this.dateOfNextUpdate != Long.MIN_VALUE ? new Date(this.dateOfNextUpdate) : null;
    }

    public synchronized void setDateOfNextUpdate(Date newValue) {
        this.checkWritePermission();
        this.dateOfNextUpdate = newValue != null ? newValue.getTime() : Long.MIN_VALUE;
    }

    public long getUserDefinedMaintenanceFrequency() {
        return this.userDefinedMaintenanceFrequency;
    }

    public synchronized void setUserDefinedMaintenanceFrequency(long newValue) {
        this.checkWritePermission();
        this.userDefinedMaintenanceFrequency = newValue;
    }

    public ScopeCode getUpdateScope() {
        return this.updateScope;
    }

    public synchronized void setUpdateScope(ScopeCode newValue) {
        this.checkWritePermission();
        this.updateScope = newValue;
    }

    public ScopeDescription getUpdateScopeDescription() {
        return this.updateScopeDescription;
    }

    public synchronized void setUpdateScopeDescription(ScopeDescription newValue) {
        this.checkWritePermission();
        this.updateScopeDescription = newValue;
    }

    public InternationalString getMaintenanceNote() {
        return this.maintenanceNote;
    }

    public synchronized void setMaintenanceNote(InternationalString newValue) {
        this.checkWritePermission();
        this.maintenanceNote = newValue;
    }

    protected void freeze() {
        super.freeze();
        this.updateScopeDescription = (ScopeDescription)MaintenanceInformationImpl.unmodifiable(this.updateScopeDescription);
        this.maintenanceNote = (InternationalString)MaintenanceInformationImpl.unmodifiable(this.maintenanceNote);
    }

    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(this.getClass())) {
            MaintenanceInformationImpl that = (MaintenanceInformationImpl)object;
            return Utilities.equals(this.maintenanceAndUpdateFrequency, that.maintenanceAndUpdateFrequency) && Utilities.equals(this.updateScope, that.updateScope) && Utilities.equals(this.updateScopeDescription, that.updateScopeDescription) && Utilities.equals(this.maintenanceNote, that.maintenanceNote) && this.userDefinedMaintenanceFrequency == that.userDefinedMaintenanceFrequency && this.dateOfNextUpdate == that.dateOfNextUpdate;
        }
        return false;
    }

    public synchronized int hashCode() {
        int code = 750088545;
        if (this.maintenanceAndUpdateFrequency != null) {
            code ^= this.maintenanceAndUpdateFrequency.hashCode();
        }
        if (this.updateScope != null) {
            code ^= this.updateScope.hashCode();
        }
        return code;
    }

    public synchronized String toString() {
        if (this.maintenanceAndUpdateFrequency != null) {
            return this.maintenanceAndUpdateFrequency.name().toLowerCase().replace('_', ' ');
        }
        return "";
    }
}

