/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.extent;

import java.util.Date;
import org.geotools.metadata.iso.MetadataEntity;
import org.opengis.metadata.extent.TemporalExtent;

public class TemporalExtentImpl
extends MetadataEntity
implements TemporalExtent {
    private static final long serialVersionUID = 3668140516657118045L;
    private long startTime = Long.MIN_VALUE;
    private long endTime = Long.MIN_VALUE;

    public TemporalExtentImpl() {
    }

    public TemporalExtentImpl(Date startTime, Date endTime) {
        this.setStartTime(startTime);
        this.setEndTime(endTime);
    }

    public synchronized Date getStartTime() {
        return this.startTime != Long.MIN_VALUE ? new Date(this.startTime) : null;
    }

    public synchronized void setStartTime(Date newValue) {
        this.checkWritePermission();
        this.startTime = newValue != null ? newValue.getTime() : Long.MIN_VALUE;
    }

    public synchronized Date getEndTime() {
        return this.endTime != Long.MIN_VALUE ? new Date(this.endTime) : null;
    }

    public synchronized void setEndTime(Date newValue) {
        this.checkWritePermission();
        this.endTime = newValue != null ? newValue.getTime() : Long.MIN_VALUE;
    }

    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(this.getClass())) {
            TemporalExtentImpl that = (TemporalExtentImpl)object;
            return this.startTime == that.startTime && this.endTime == that.endTime;
        }
        return false;
    }

    public synchronized int hashCode() {
        long code = this.startTime + 37L * this.endTime;
        return (int)code ^ (int)(code >>> 32) ^ 0x8190BB5D;
    }

    public String toString() {
        return String.valueOf(this.startTime);
    }
}

