/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.citation;

import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.geotools.metadata.iso.citation.OnLineResourceImpl;
import org.geotools.metadata.iso.citation.ResponsiblePartyImpl;
import org.geotools.util.SimpleInternationalString;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.OnLineFunction;
import org.opengis.metadata.citation.PresentationForm;
import org.opengis.metadata.citation.Role;
import org.opengis.util.InternationalString;

public final class Citations {
    public static final Citation OGC;
    public static final Citation OPEN_GIS;
    public static final Citation ESRI;
    public static final Citation ORACLE;
    public static final Citation GEOTOOLS;
    public static final Citation WMS;
    public static final Citation GEOTIFF;
    public static final Citation JAI;
    public static final Citation EPSG;
    public static final Citation AUTO;
    public static final Citation AUTO2;
    public static final Citation CRS;
    private static final Citation[] AUTHORITIES;

    private Citations() {
    }

    public static Citation fromName(String title) {
        for (int i = 0; i < AUTHORITIES.length; ++i) {
            Citation citation = AUTHORITIES[i];
            if (!Citations.titleMatches(citation, title)) continue;
            return citation;
        }
        return new CitationImpl(title);
    }

    public static boolean titleMatches(Citation c1, Citation c2) {
        InternationalString candidate = c2.getTitle();
        Iterator iterator = null;
        while (true) {
            String asString;
            if (Citations.titleMatches(c1, asString = candidate.toString(Locale.US))) {
                return true;
            }
            String asLocalized = ((Object)candidate).toString();
            if (asLocalized != asString && Citations.titleMatches(c1, asLocalized)) {
                return true;
            }
            if (iterator == null) {
                Collection titles = c2.getAlternateTitles();
                if (titles == null) break;
                iterator = titles.iterator();
            }
            if (!iterator.hasNext()) break;
            candidate = (InternationalString)iterator.next();
        }
        return false;
    }

    public static boolean titleMatches(Citation citation, String title) {
        title = title.trim();
        InternationalString candidate = citation.getTitle();
        Iterator iterator = null;
        while (true) {
            String asString;
            if ((asString = candidate.toString(Locale.US)).trim().equalsIgnoreCase(title)) {
                return true;
            }
            String asLocalized = ((Object)candidate).toString();
            if (asLocalized != asString && asLocalized.trim().equalsIgnoreCase(title)) {
                return true;
            }
            if (iterator == null) {
                Collection titles = citation.getAlternateTitles();
                if (titles == null) break;
                iterator = titles.iterator();
            }
            if (!iterator.hasNext()) break;
            candidate = (InternationalString)iterator.next();
        }
        return false;
    }

    public static boolean identifierMatches(Citation c1, Citation c2) {
        Collection identifiers2 = c2.getIdentifiers();
        Iterator ids1_iter = c1.getIdentifiers().iterator();
        if (!ids1_iter.hasNext()) {
            if (identifiers2.isEmpty()) {
                return Citations.titleMatches(c1, c2);
            }
            return Citations.identifierMatches(c2, c1);
        }
        Collection types2 = c2.getIdentifierTypes();
        Iterator types1_iter = c1.getIdentifierTypes().iterator();
        do {
            String identifier1 = ((String)ids1_iter.next()).trim();
            if (!types1_iter.hasNext() || types2.isEmpty()) {
                if (!Citations.identifierMatches(c2, identifier1)) continue;
                return true;
            }
            String type1 = ((String)types1_iter.next()).trim();
            Iterator types2_iter = types2.iterator();
            Iterator ids2_iter = identifiers2.iterator();
            while (ids2_iter.hasNext()) {
                String type2;
                String identifier2 = ((String)ids2_iter.next()).trim();
                if (types2_iter.hasNext() && !type1.equalsIgnoreCase(type2 = ((String)types2_iter.next()).trim()) || !identifier1.equalsIgnoreCase(identifier2)) continue;
                return true;
            }
        } while (ids1_iter.hasNext());
        return false;
    }

    public static boolean identifierMatches(Citation citation, String identifier) {
        identifier = identifier.trim();
        Collection identifiers = citation.getIdentifiers();
        Iterator it = identifiers.iterator();
        while (it.hasNext()) {
            String id = ((String)it.next()).trim();
            if (!identifier.equalsIgnoreCase(id)) continue;
            return true;
        }
        if (identifiers.isEmpty()) {
            return Citations.titleMatches(citation, identifier);
        }
        return false;
    }

    static {
        CitationImpl c = new CitationImpl(ResponsiblePartyImpl.OGC);
        c.getAlternateTitles().add(new SimpleInternationalString("OGC"));
        c.getPresentationForm().add(PresentationForm.DOCUMENT_DIGITAL);
        c.freeze();
        OGC = c;
        c = new CitationImpl(ResponsiblePartyImpl.OPEN_GIS);
        Collection alt = c.getAlternateTitles();
        alt.add(new SimpleInternationalString("OpenGIS"));
        alt.addAll(OGC.getAlternateTitles());
        c.getPresentationForm().add(PresentationForm.DOCUMENT_DIGITAL);
        c.freeze();
        OPEN_GIS = c;
        c = new CitationImpl(ResponsiblePartyImpl.ESRI);
        c.freeze();
        ESRI = c;
        c = new CitationImpl(ResponsiblePartyImpl.ORACLE);
        c.freeze();
        ORACLE = c;
        c = new CitationImpl(ResponsiblePartyImpl.GEOTOOLS);
        c.freeze();
        GEOTOOLS = c;
        c = new CitationImpl("Web Map Service");
        Collection titles = c.getAlternateTitles();
        titles.add(new SimpleInternationalString("WMS"));
        titles.add(new SimpleInternationalString("WMS 1.3.0"));
        titles.add(new SimpleInternationalString("OGC 04-024"));
        titles.add(new SimpleInternationalString("ISO 19128"));
        Collection parties = c.getCitedResponsibleParties();
        parties.add(ResponsiblePartyImpl.OGC);
        parties.add(ResponsiblePartyImpl.OGC(Role.PUBLISHER, OnLineResourceImpl.WMS));
        c.getPresentationForm().add(PresentationForm.DOCUMENT_DIGITAL);
        c.freeze();
        WMS = c;
        c = new CitationImpl(ResponsiblePartyImpl.GEOTIFF);
        c.getPresentationForm().add(PresentationForm.DOCUMENT_DIGITAL);
        c.freeze();
        GEOTIFF = c;
        c = new CitationImpl("Java Advanced Imaging");
        c.getAlternateTitles().add(new SimpleInternationalString("JAI"));
        c.getCitedResponsibleParties().add(ResponsiblePartyImpl.SUN_MICROSYSTEMS);
        c.freeze();
        JAI = c;
        c = new CitationImpl(ResponsiblePartyImpl.EPSG);
        c.addAuthority("EPSG");
        c.getPresentationForm().add(PresentationForm.TABLE_DIGITAL);
        c.freeze();
        EPSG = c;
        c = new CitationImpl("Automatic Projections");
        c.addAuthority("AUTO");
        Collection parties2 = c.getCitedResponsibleParties();
        parties2.add(ResponsiblePartyImpl.OGC);
        parties2.add(ResponsiblePartyImpl.OGC(Role.PUBLISHER, OnLineFunction.DOWNLOAD, "http://www.opengis.org/docs/01-068r3.pdf"));
        c.getPresentationForm().add(PresentationForm.DOCUMENT_DIGITAL);
        c.freeze();
        AUTO = c;
        c = new CitationImpl("Automatic Projections");
        c.addAuthority("AUTO2");
        parties2 = c.getCitedResponsibleParties();
        parties2.add(ResponsiblePartyImpl.OGC);
        parties2.add(ResponsiblePartyImpl.OGC(Role.PUBLISHER, OnLineResourceImpl.WMS));
        c.getPresentationForm().add(PresentationForm.DOCUMENT_DIGITAL);
        c.freeze();
        AUTO2 = c;
        c = new CitationImpl("Web Map Service CRS");
        c.addAuthority("CRS");
        c.getCitedResponsibleParties().addAll(AUTO2.getCitedResponsibleParties());
        c.getPresentationForm().add(PresentationForm.DOCUMENT_DIGITAL);
        c.freeze();
        CRS = c;
        AUTHORITIES = new Citation[]{OGC, OPEN_GIS, ESRI, ORACLE, GEOTOOLS, WMS, GEOTIFF, JAI, EPSG, AUTO, AUTO2, CRS};
    }
}

