/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.citation;

import java.util.Collection;
import java.util.Iterator;
import org.geotools.metadata.iso.MetadataEntity;
import org.geotools.resources.Utilities;
import org.opengis.metadata.citation.Address;
import org.opengis.util.InternationalString;

public class AddressImpl
extends MetadataEntity
implements Address {
    private static final long serialVersionUID = 2278687294173262546L;
    private InternationalString administrativeArea;
    private InternationalString city;
    private InternationalString country;
    private String postalCode;
    private Collection deliveryPoints;
    private Collection electronicMailAddresses;

    public InternationalString getAdministrativeArea() {
        return this.administrativeArea;
    }

    public synchronized void setAdministrativeArea(InternationalString newValue) {
        this.checkWritePermission();
        this.administrativeArea = newValue;
    }

    public InternationalString getCity() {
        return this.city;
    }

    public synchronized void setCity(InternationalString newValue) {
        this.checkWritePermission();
        this.city = newValue;
    }

    public InternationalString getCountry() {
        return this.country;
    }

    public synchronized void setCountry(InternationalString newValue) {
        this.checkWritePermission();
        this.country = newValue;
    }

    public synchronized Collection getDeliveryPoints() {
        this.deliveryPoints = this.nonNullCollection(this.deliveryPoints, String.class);
        return this.deliveryPoints;
    }

    public synchronized void setDeliveryPoints(Collection newValues) {
        this.deliveryPoints = this.copyCollection(newValues, this.deliveryPoints, String.class);
    }

    public synchronized Collection getElectronicMailAddresses() {
        this.electronicMailAddresses = this.nonNullCollection(this.electronicMailAddresses, String.class);
        return this.electronicMailAddresses;
    }

    public synchronized void setElectronicMailAddresses(Collection newValues) {
        this.electronicMailAddresses = this.copyCollection(newValues, this.electronicMailAddresses, String.class);
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public synchronized void setPostalCode(String newValue) {
        this.checkWritePermission();
        this.postalCode = newValue;
    }

    protected void freeze() {
        super.freeze();
        this.administrativeArea = (InternationalString)AddressImpl.unmodifiable(this.administrativeArea);
        this.city = (InternationalString)AddressImpl.unmodifiable(this.city);
        this.country = (InternationalString)AddressImpl.unmodifiable(this.country);
        this.deliveryPoints = (Collection)AddressImpl.unmodifiable(this.deliveryPoints);
        this.electronicMailAddresses = (Collection)AddressImpl.unmodifiable(this.electronicMailAddresses);
    }

    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(this.getClass())) {
            AddressImpl that = (AddressImpl)object;
            return Utilities.equals(this.administrativeArea, that.administrativeArea) && Utilities.equals(this.city, that.city) && Utilities.equals(this.country, that.country) && Utilities.equals(this.postalCode, that.postalCode) && Utilities.equals(this.deliveryPoints, that.deliveryPoints) && Utilities.equals(this.electronicMailAddresses, that.electronicMailAddresses);
        }
        return false;
    }

    public synchronized int hashCode() {
        int code = 1667543762;
        if (this.postalCode != null) {
            code ^= this.postalCode.hashCode();
        }
        if (this.electronicMailAddresses != null) {
            code ^= ((Object)this.electronicMailAddresses).hashCode();
        }
        return code;
    }

    public synchronized String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.deliveryPoints != null) {
            Iterator it = this.deliveryPoints.iterator();
            while (it.hasNext()) {
                AddressImpl.appendLineSeparator(buffer);
                buffer.append(it.next());
            }
        }
        if (this.city != null) {
            AddressImpl.appendLineSeparator(buffer);
            buffer.append((Object)this.city);
            if (this.administrativeArea != null) {
                buffer.append(" (");
                buffer.append((Object)this.administrativeArea);
                buffer.append(')');
            }
        }
        if (this.country != null) {
            AddressImpl.appendLineSeparator(buffer);
            buffer.append((Object)this.country);
        }
        return buffer.toString();
    }
}

