/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.io;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.geotools.resources.Arguments;
import org.geotools.resources.Utilities;

public class NumberedLineWriter
extends FilterWriter {
    public static final PrintWriter OUT = new PrintWriter((Writer)new Uncloseable(Arguments.getWriter(System.out)), true);
    private int width = 3;
    private int current = 1;
    private boolean newLine = true;
    private boolean waitLF;

    public NumberedLineWriter(Writer out) {
        super(out);
    }

    public int getLineNumber() {
        return this.current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLineNumber(int line) {
        Object object = this.lock;
        synchronized (object) {
            this.current = line;
        }
    }

    private void doWrite(int c) throws IOException {
        if (this.newLine && (c != 10 || !this.waitLF)) {
            String number = String.valueOf(this.current++);
            this.out.write(91);
            this.out.write(Utilities.spaces(this.width - number.length()));
            this.out.write(number);
            this.out.write("] ");
        }
        this.out.write(c);
        this.newLine = c == 13 || c == 10;
        if (this.newLine) {
            this.waitLF = c == 13;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int c) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.doWrite(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] buffer, int offset, int length) throws IOException {
        int upper = offset + length;
        Object object = this.lock;
        synchronized (object) {
            block3: while (offset < upper) {
                if (this.newLine) {
                    this.doWrite(buffer[offset++]);
                    continue;
                }
                int lower = offset;
                do {
                    char c;
                    if ((c = buffer[offset]) != '\r' && c != '\n') continue;
                    this.out.write(buffer, lower, offset - lower);
                    this.doWrite(c);
                    ++offset;
                    continue block3;
                } while (++offset < upper);
                this.out.write(buffer, lower, offset - lower);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String string, int offset, int length) throws IOException {
        int upper = offset + length;
        Object object = this.lock;
        synchronized (object) {
            block3: while (offset < upper) {
                if (this.newLine) {
                    this.doWrite(string.charAt(offset++));
                    continue;
                }
                int lower = offset;
                do {
                    char c;
                    if ((c = string.charAt(offset)) != '\r' && c != '\n') continue;
                    this.out.write(string, lower, offset - lower);
                    this.doWrite(c);
                    ++offset;
                    continue block3;
                } while (++offset < upper);
                this.out.write(string, lower, offset - lower);
                break;
            }
        }
    }

    private static final class Uncloseable
    extends NumberedLineWriter {
        public Uncloseable(Writer out) {
            super(out);
        }

        public void close() throws IOException {
            this.flush();
        }
    }
}

