/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.j3d.ImageComponent3D;
import javax.media.j3d.ImageComponentRetained;
import javax.media.j3d.ImageComponentUpdateInfo;
import javax.media.j3d.J3dI18N;

class ImageComponent3DRetained
extends ImageComponentRetained {
    ImageComponent3DRetained() {
    }

    void setDepth(int n) {
        this.depth = n;
    }

    int getDepth() {
        return this.depth;
    }

    void set(int n, BufferedImage bufferedImage) {
        this.geomLock.getLock();
        if (this.byReference) {
            this.setRefImage(bufferedImage, 0);
        }
        if (this.imageData == null) {
            this.abgrSupported = true;
            this.imageTypeIsSupported = this.isImageTypeSupported(bufferedImage);
            this.imageData = this.createRenderedImageDataObject(null);
        } else if (this.getImageType() != this.evaluateImageType(bufferedImage)) {
            // empty if block
        }
        if (this.imageTypeIsSupported) {
            this.copySupportedImageToImageData(bufferedImage, n, this.imageData);
        } else {
            this.copyUnsupportedImageToImageData(bufferedImage, n, this.imageData);
        }
        this.geomLock.unLock();
        if (this.source.isLive()) {
            this.sendMessage(1, null);
        }
    }

    void set(int n, RenderedImage renderedImage) {
        int n2 = renderedImage.getWidth();
        int n3 = renderedImage.getHeight();
        if (n2 != this.width) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent3D2"));
        }
        if (n3 != this.height) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent3D4"));
        }
        if (renderedImage instanceof BufferedImage) {
            this.set(n, (BufferedImage)renderedImage);
        } else {
            ColorModel colorModel = renderedImage.getColorModel();
            WritableRaster writableRaster = renderedImage.copyData(null);
            BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
            this.set(n, bufferedImage);
        }
    }

    RenderedImage[] getRenderedImage() {
        RenderedImage[] renderedImageArray = new RenderedImage[this.depth];
        if (!this.byReference) {
            for (int i = 0; i < this.depth; ++i) {
                renderedImageArray[i] = this.imageData.createBufferedImage(i);
            }
        } else {
            for (int i = 0; i < this.depth; ++i) {
                renderedImageArray[i] = this.imageData.createBufferedImage(i);
            }
        }
        return renderedImageArray;
    }

    BufferedImage[] getImage() {
        BufferedImage[] bufferedImageArray = new BufferedImage[this.depth];
        if (!this.byReference) {
            for (int i = 0; i < this.depth; ++i) {
                bufferedImageArray[i] = this.imageData.createBufferedImage(i);
            }
        } else {
            for (int i = 0; i < this.depth; ++i) {
                bufferedImageArray[i] = this.imageData.createBufferedImage(i);
                if (bufferedImageArray[i] instanceof BufferedImage) continue;
                throw new IllegalStateException(J3dI18N.getString("ImageComponent3DRetained0"));
            }
        }
        return bufferedImageArray;
    }

    RenderedImage getImage(int n) {
        if (!this.byReference) {
            return this.imageData.createBufferedImage(n);
        }
        return (RenderedImage)this.getRefImage(n);
    }

    void updateData(ImageComponent3D.Updater updater, int n, int n2, int n3, int n4, int n5) {
        this.geomLock.getLock();
        updater.updateData((ImageComponent3D)this.source, n, n2, n3, n4, n5);
        RenderedImage renderedImage = (RenderedImage)this.getRefImage(n);
        assert (renderedImage != null);
        assert (this.imageData != null);
        int n6 = n2 + renderedImage.getMinX();
        int n7 = n3 + renderedImage.getMinY();
        if (this.imageTypeIsSupported) {
            if (renderedImage instanceof BufferedImage) {
                this.copyImageLineByLine((BufferedImage)renderedImage, n6, n7, n2, n3, n, n4, n5, this.imageData);
            } else {
                this.copySupportedImageToImageData(renderedImage, n6, n7, n2, n3, n, n4, n5, this.imageData);
            }
        } else if (renderedImage instanceof BufferedImage) {
            this.copyUnsupportedImageToImageData((BufferedImage)renderedImage, n6, n7, n2, n3, n, n4, n5, this.imageData);
        } else {
            this.copyUnsupportedImageToImageData(renderedImage, n6, n7, n2, n3, n, n4, n5, this.imageData);
        }
        this.geomLock.unLock();
        if (this.source.isLive()) {
            ImageComponentUpdateInfo imageComponentUpdateInfo = new ImageComponentUpdateInfo();
            imageComponentUpdateInfo.x = n2;
            imageComponentUpdateInfo.y = n3;
            imageComponentUpdateInfo.z = n;
            imageComponentUpdateInfo.width = n4;
            imageComponentUpdateInfo.height = n5;
            this.sendMessage(2, imageComponentUpdateInfo);
        }
    }

    void setSubImage(int n, RenderedImage renderedImage, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (!this.isSubImageTypeEqual(renderedImage)) {
            throw new IllegalStateException(J3dI18N.getString("ImageComponent2D6"));
        }
        assert (!this.byReference);
        assert (this.imageData != null);
        this.geomLock.getLock();
        if (this.imageTypeIsSupported) {
            if (renderedImage instanceof BufferedImage) {
                this.copyImageLineByLine((BufferedImage)renderedImage, n4, n5, n6, n7, n, n2, n3, this.imageData);
            } else {
                this.copySupportedImageToImageData(renderedImage, n4, n5, n6, n7, n, n2, n3, this.imageData);
            }
        } else if (renderedImage instanceof BufferedImage) {
            this.copyUnsupportedImageToImageData((BufferedImage)renderedImage, n4, n5, n6, n7, n, n2, n3, this.imageData);
        } else {
            this.copyUnsupportedImageToImageData(renderedImage, n4, n5, n6, n7, n, n2, n3, this.imageData);
        }
        this.geomLock.unLock();
        if (this.source.isLive()) {
            ImageComponentUpdateInfo imageComponentUpdateInfo = new ImageComponentUpdateInfo();
            imageComponentUpdateInfo.x = n6;
            imageComponentUpdateInfo.y = n7;
            imageComponentUpdateInfo.z = n;
            imageComponentUpdateInfo.width = n2;
            imageComponentUpdateInfo.height = n3;
            this.sendMessage(2, imageComponentUpdateInfo);
        }
    }

    ImageComponentRetained createNextLevelMipMapImage() {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.width > 1) {
            n4 = this.width >> 1;
            n3 = 2;
        } else {
            n4 = 1;
            n3 = 1;
        }
        if (this.height > 1) {
            n2 = this.height >> 1;
            n = 2;
        } else {
            n2 = 1;
            n = 1;
        }
        ImageComponent3DRetained imageComponent3DRetained = new ImageComponent3DRetained();
        imageComponent3DRetained.processParams(this.getFormat(), n4, n2, this.depth);
        imageComponent3DRetained.setImageFormatType(this.getImageFormatType());
        imageComponent3DRetained.setUnitsPerPixel(this.getUnitsPerPixel());
        imageComponent3DRetained.imageData = imageComponent3DRetained.createRenderedImageDataObject(null);
        for (int i = 0; i < this.depth; ++i) {
            imageComponent3DRetained.scaleImage(n3, n, i, this);
        }
        return imageComponent3DRetained;
    }
}

