/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.indexed;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.logging.Logger;
import org.geotools.data.shapefile.indexed.IndexedFidReader;
import org.geotools.data.shapefile.indexed.IndexedFidWriter;
import org.geotools.data.shapefile.shp.IndexFile;

public class FidIndexer {
    static Logger LOGGER = Logger.getLogger("org.geotools.data.shapefile");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized URL generate(URL shpURL) throws IOException {
        URL uRL;
        URL indexURL;
        URL fixURL;
        int indexslash;
        String filename;
        IndexFile indexFile;
        IndexedFidWriter writer;
        block27: {
            block25: {
                LOGGER.info("Generating fids for " + shpURL);
                writer = null;
                indexFile = null;
                try {
                    filename = URLDecoder.decode(shpURL.toString(), "US-ASCII");
                    filename = filename.substring(0, filename.lastIndexOf(".shp"));
                }
                catch (UnsupportedEncodingException use) {
                    throw new MalformedURLException("Unable to decode " + shpURL + " cause " + use.getMessage());
                }
                indexslash = filename.lastIndexOf(File.pathSeparator);
                if (indexslash == -1) {
                    indexslash = 0;
                }
                fixURL = new URL(filename + ".fix");
                indexURL = new URL(filename + ".shx");
                if (!new File(fixURL.getFile()).exists()) break block25;
                URL uRL2 = fixURL;
                Object var11_11 = null;
                try {
                    if (indexFile != null) {
                        indexFile.close();
                    }
                }
                finally {
                    if (writer != null) {
                        writer.close();
                    }
                }
                return uRL2;
            }
            if (new File(indexURL.getFile()).exists()) break block27;
            URL uRL3 = null;
            Object var11_12 = null;
            try {
                if (indexFile != null) {
                    indexFile.close();
                }
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
            return uRL3;
        }
        try {
            indexFile = new IndexFile(FidIndexer.getReadChannel(indexURL));
            FileChannel writeChannel = FidIndexer.getWriteChannel(fixURL);
            writer = new IndexedFidWriter(writeChannel, new IndexedFidReader(filename.substring(indexslash), writeChannel));
            int j = indexFile.getRecordCount();
            for (int i = 0; i < j; ++i) {
                writer.next();
            }
            uRL = fixURL;
            Object var11_13 = null;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            try {
                if (indexFile != null) {
                    indexFile.close();
                }
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
            throw throwable;
        }
        try {
            if (indexFile != null) {
                indexFile.close();
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        return uRL;
    }

    protected static ReadableByteChannel getReadChannel(URL url) throws IOException {
        ReadableByteChannel channel = null;
        if (url.getProtocol().equals("file")) {
            File file = null;
            file = url.getHost() != null && !url.getHost().equals("") ? new File(url.getHost() + ":" + url.getFile()) : new File(url.getFile());
            if (!file.exists()) {
                throw new IOException("File doesn't exist: " + file);
            }
            if (!file.canRead()) {
                throw new IOException("File isn't readable: " + file);
            }
            FileInputStream in = new FileInputStream(file);
            channel = in.getChannel();
        } else {
            InputStream in = url.openConnection().getInputStream();
            channel = Channels.newChannel(in);
        }
        return channel;
    }

    protected static FileChannel getWriteChannel(URL url) throws IOException {
        if (url.getProtocol().equals("file")) {
            File file = null;
            file = url.getHost() != null && !url.getHost().equals("") ? new File(url.getHost() + ":" + url.getFile()) : new File(url.getFile());
            RandomAccessFile raf = new RandomAccessFile(file, "rw");
            FileChannel channel = raf.getChannel();
            channel.lock();
            return channel;
        }
        return null;
    }
}

