/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.jams.runtime;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Set;
import org.unijena.jams.runtime.JAMSRuntime;

public class ClassManager {
    private static final Class[] parameters = new Class[]{URL.class};
    private static Set<URL> urls = new HashSet<URL>();

    public static void addFile(String s, JAMSRuntime rt) throws IOException {
        File f = new File(s);
        ClassManager.addFile(f, rt);
    }

    public static void addFile(File f, JAMSRuntime rt) throws IOException, MalformedURLException {
        ClassManager.addURL(f.toURI().toURL(), rt);
    }

    public static void addURL(URL u, JAMSRuntime rt) throws IOException {
        if (urls.contains(u)) {
            return;
        }
        urls.add(u);
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        try {
            Method method = sysclass.getDeclaredMethod("addURL", parameters);
            method.setAccessible(true);
            method.invoke((Object)sysloader, u);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IOException("Error, could not add URL to system classloader");
        }
    }

    public static void addLibs(String[] libdirs, JAMSRuntime rt) throws IOException {
        for (int i = 0; i < libdirs.length; ++i) {
            File dir = new File(libdirs[i]);
            if (!dir.exists()) {
                rt.println("Library " + dir.getAbsolutePath() + " does not exist");
                continue;
            }
            if (dir.isDirectory()) {
                File[] f = dir.listFiles();
                for (int j = 0; j < f.length; ++j) {
                    if (!f[j].getName().endsWith(".jar")) continue;
                    ClassManager.addFile(f[j], rt);
                }
                continue;
            }
            ClassManager.addFile(dir, rt);
        }
        rt.println("Created class loader using " + urls, 1);
    }
}

