/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.jams.model;

import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSTimeInterval;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSComponentEnumerator;
import org.unijena.jams.model.JAMSContext;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="JAMS temporal context", author="Sven Kralisch", date="31. Juli 2005", description="This component represents a JAMS context which can be used to represent temporal contexts in environmental models")
public class JAMSTemporalContext
extends JAMSContext {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Time interval of temporal context")
    public JAMSTimeInterval timeInterval;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Current date of temporal context")
    public JAMSCalendar current;
    JAMSCalendar lastValue;

    public JAMSTemporalContext() {
        this.current = new JAMSCalendar();
    }

    public JAMSTemporalContext(JAMSTimeInterval timeInterval) {
        this();
        this.timeInterval = timeInterval;
    }

    public JAMSTemporalContext(JAMSCalendar start, JAMSCalendar end, int timeUnit, int timeUnitCount) {
        this.timeInterval = new JAMSTimeInterval(start, end, timeUnit, timeUnitCount);
    }

    @Override
    public void init() {
        super.init();
        this.lastValue = this.timeInterval.getEnd().clone();
        this.lastValue.add(this.timeInterval.getTimeUnit(), -this.timeInterval.getTimeUnitCount());
        this.lastValue.add(14, 1);
    }

    @Override
    public JAMSComponentEnumerator getRunEnumerator() {
        return new RunEnumerator();
    }

    @Override
    public long getNumberOfIterations() {
        return this.timeInterval.getNumberOfTimesteps();
    }

    class RunEnumerator
    implements JAMSComponentEnumerator {
        JAMSComponentEnumerator ce;

        RunEnumerator() {
            this.ce = JAMSTemporalContext.this.getChildrenEnumerator();
        }

        @Override
        public boolean hasNext() {
            boolean nextTime = JAMSTemporalContext.this.current.before(JAMSTemporalContext.this.lastValue);
            boolean nextComp = this.ce.hasNext();
            return nextTime || nextComp;
        }

        @Override
        public JAMSComponent next() {
            if (!this.ce.hasNext() && JAMSTemporalContext.this.current.before(JAMSTemporalContext.this.lastValue)) {
                JAMSTemporalContext.this.current.add(JAMSTemporalContext.this.timeInterval.getTimeUnit(), JAMSTemporalContext.this.timeInterval.getTimeUnitCount());
                this.ce.reset();
            }
            return this.ce.next();
        }

        @Override
        public void reset() {
            JAMSTemporalContext.this.current.setValue(JAMSTemporalContext.this.timeInterval.getStart().getValue());
            this.ce.reset();
        }
    }
}

