/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.jams.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import org.unijena.jams.data.JAMSTimeInterval;
import org.unijena.jams.io.CacheDataException;
import org.unijena.jams.io.JAMSCacheOutputStream;

public class JAMSCacheInputStream
extends ObjectInputStream {
    private int neededByteLength;
    private int givenByteLength;
    private String givenID;
    private String neededID;
    private JAMSTimeInterval givenTimeInterval;
    private JAMSTimeInterval neededTimeInterval;
    private long givenMultiplier;
    private long neededMultiplier;

    public JAMSCacheInputStream(InputStream in, int bitLength, String id, JAMSTimeInterval timeInterval, long multiplier) throws IOException {
        super(in);
        this.neededByteLength = Math.round(bitLength / 8);
        this.neededID = id;
        this.neededTimeInterval = timeInterval;
        this.neededMultiplier = multiplier;
        this.init();
    }

    private void init() throws IOException {
        try {
            this.givenByteLength = Math.round(this.readInt() / 8);
            this.givenID = (String)this.readObject();
            this.givenTimeInterval = new JAMSTimeInterval();
            this.givenTimeInterval.setValue((String)this.readObject());
            this.givenMultiplier = this.readLong();
            if (this.givenByteLength != this.neededByteLength) {
                throw new CacheDataException("Given and needed data types do not match in cache input stream: " + this.givenByteLength + " <-> " + this.neededByteLength);
            }
            if (!this.givenID.equals(this.neededID)) {
                throw new CacheDataException("Given and needed data IDs do not match in cache input stream " + this.givenID + " <-> " + this.neededID);
            }
            if (this.givenMultiplier != this.neededMultiplier) {
                throw new CacheDataException("Given and needed multipliers do not match in cache input stream " + this.givenMultiplier + " <-> " + this.neededMultiplier);
            }
            if (!this.givenTimeInterval.encloses(this.neededTimeInterval)) {
                throw new CacheDataException("Given and needed time intervals do not match in cache input stream " + this.givenTimeInterval + " <-> " + this.neededTimeInterval);
            }
            long offset = this.givenTimeInterval.getStartOffset(this.neededTimeInterval);
            this.skip(offset * (long)this.givenByteLength * this.givenMultiplier);
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        int j;
        JAMSTimeInterval ti = new JAMSTimeInterval();
        ti.setValue("1996-11-01 7:30 2000-10-31 7:30 6 1");
        int hruCount = 37;
        try {
            JAMSCacheOutputStream writer = new JAMSCacheOutputStream(new BufferedOutputStream(new FileOutputStream("d:/test.bin")), 64, "myData", ti, hruCount);
            for (int i = 0; i < 1000; ++i) {
                for (j = 0; j < hruCount; ++j) {
                    writer.writeDouble(i);
                }
            }
            writer.flush();
            writer.close();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        JAMSTimeInterval ti2 = new JAMSTimeInterval();
        ti2.setValue("1997-01-03 7:30 1997-12-31 7:30 6 1");
        try {
            JAMSCacheInputStream reader = new JAMSCacheInputStream(new BufferedInputStream(new FileInputStream("d:/test.bin")), 64, "myData", ti2, hruCount);
            for (j = 0; j < hruCount; ++j) {
                System.out.println(reader.readDouble());
            }
            System.out.println(reader.readDouble());
        }
        catch (CacheDataException ex) {
            System.out.println("cache data problem");
        }
        catch (IOException ex) {
            System.out.println("file problem");
        }
    }
}

