/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.jams.dataaccess;

import org.unijena.jams.data.JAMSData;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSLong;
import org.unijena.jams.dataaccess.JAMSEntityDataAccessor;

public class LongAccessor
implements JAMSEntityDataAccessor {
    JAMSLong componentObject;
    JAMSLong[] entityObject;
    int index;
    int accessType;

    public LongAccessor(JAMSEntity[] entities, JAMSData dataObject, String attributeName, int accessType) throws JAMSEntity.NoSuchAttributeException {
        this.entityObject = new JAMSLong[entities.length];
        for (int i = 0; i < entities.length; ++i) {
            if (entities[i].existsAttribute(attributeName)) {
                try {
                    this.entityObject[i] = (JAMSLong)entities[i].getObject(attributeName);
                }
                catch (JAMSEntity.NoSuchAttributeException nsae) {}
                continue;
            }
            if (accessType != 0) {
                this.entityObject[i] = new JAMSLong();
                entities[i].setObject(attributeName, this.entityObject[i]);
                continue;
            }
            throw new JAMSEntity.NoSuchAttributeException("Attribute " + attributeName + " does not exist!");
        }
        this.accessType = accessType;
        this.componentObject = (JAMSLong)dataObject;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public void read() {
        this.componentObject.setValue(this.entityObject[this.index].getValue());
    }

    @Override
    public void write() {
        this.entityObject[this.index].setValue(this.componentObject.getValue());
    }

    @Override
    public int getAccessType() {
        return this.accessType;
    }
}

