/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.jams.data;

import java.util.StringTokenizer;
import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSSerializableData;

public class JAMSTimeInterval
extends JAMSSerializableData {
    protected JAMSCalendar start = new JAMSCalendar();
    protected JAMSCalendar end = new JAMSCalendar();
    protected int timeUnit = 6;
    protected int timeUnitCount = 1;
    private long timestepCount = -1L;

    public JAMSTimeInterval() {
    }

    public JAMSTimeInterval(JAMSCalendar start, JAMSCalendar end, int timeUnit, int timeUnitCount) {
        this.start = start;
        this.end = end;
        this.timeUnit = timeUnit;
        this.timeUnitCount = timeUnitCount;
    }

    @Override
    public void setValue(String value) {
        try {
            StringTokenizer st = new StringTokenizer(value);
            String startDate = st.nextToken();
            String startTime = st.nextToken();
            String endDate = st.nextToken();
            String endTime = st.nextToken();
            String unit = st.nextToken();
            String count = st.nextToken();
            this.start.setValue(startDate + " " + startTime);
            this.end.setValue(endDate + " " + endTime);
            this.timeUnit = Integer.parseInt(unit);
            this.timeUnitCount = Integer.parseInt(count);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean encloses(JAMSTimeInterval ti) {
        return this.start.compareTo(ti.start) <= 0 && this.end.compareTo(ti.end) >= 0;
    }

    public long getStartOffset(JAMSTimeInterval ti) {
        if (!this.encloses(ti)) {
            return -1L;
        }
        JAMSTimeInterval tmp = new JAMSTimeInterval();
        tmp.setValue(this.getValue());
        JAMSCalendar start = new JAMSCalendar();
        start.setValue(this.start);
        JAMSCalendar end = new JAMSCalendar();
        end.setValue(ti.start);
        tmp.setStart(start);
        tmp.setEnd(end);
        long offset = tmp.getNumberOfTimesteps() - 1L;
        return offset;
    }

    public String getValue() {
        return this.start + " " + this.end + " " + this.timeUnit + " " + this.timeUnitCount;
    }

    @Override
    public String toString() {
        return this.getValue();
    }

    public JAMSCalendar getStart() {
        return this.start;
    }

    public void setStart(JAMSCalendar start) {
        this.start = start;
        this.timestepCount = -1L;
    }

    public JAMSCalendar getEnd() {
        return this.end;
    }

    public void setEnd(JAMSCalendar end) {
        this.end = end;
        this.timestepCount = -1L;
    }

    public int getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(int timeUnit) {
        this.timeUnit = timeUnit;
        this.timestepCount = -1L;
    }

    public int getTimeUnitCount() {
        return this.timeUnitCount;
    }

    public void setTimeUnitCount(int timeUnitCount) {
        this.timeUnitCount = timeUnitCount;
        this.timestepCount = -1L;
    }

    public long getNumberOfTimesteps() {
        if (this.timestepCount < 0L) {
            long count = 0L;
            JAMSCalendar start = new JAMSCalendar();
            start.setValue(this.getStart().getValue());
            JAMSCalendar end = new JAMSCalendar();
            end.setValue(this.getEnd().getValue());
            end.setTimeInMillis(end.getTimeInMillis() + 1L);
            while (start.before(end)) {
                start.add(this.timeUnit, this.timeUnitCount);
                ++count;
            }
            this.timestepCount = count;
        }
        return this.timestepCount;
    }
}

