/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package reg.sample;

import gw.layers.SimpleFeatureLayer;
import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.avlist.AVKey;
import gw.events.FeatureSelectionListener;
import gw.layers.LayerFactory;
import gw.layers.SimpleFeatureAnnotationLayer;
import gw.util.WorldWindUtils;
import java.io.File;
import javax.swing.UIManager;
import org.opengis.feature.simple.SimpleFeature;

public class ShapeExample extends javax.swing.JFrame implements FeatureSelectionListener {

    SimpleFeatureLayer sf;
    SimpleFeatureAnnotationLayer sal;

    /** Creates new form ShapeExample */
    public ShapeExample() throws Exception {
        initComponents();

        if (wwpanel.getModel() == null) {
            wwpanel.setModel((Model) WorldWind.createConfigurationComponent(
                    AVKey.MODEL_CLASS_NAME));
        }

        sf = LayerFactory.fromShapefile(new File("C:\\Projekte\\uni\\tlug\\dataReg\\data\\hrus_dd polygon.shp"), wwpanel);
        sf.redraw();
        sf.addFeatureSelectionListener(this);
        wwpanel.getModel().getLayers().add(sf);
        sf.setPickEnabled(false);

    }

    @Override
    public boolean featureSelected(SimpleFeature selected) {
        if (selected != null) {
            String txt = "";
            for (int i = 0; i < selected.getFeatureType().getTypes().size(); i++) {
                txt += selected.getFeatureType().getType(i).getName().getLocalPart() + ": " + selected.getAttribute(i).toString() + "\n";
            }
            textbox.setText(txt);
        }
        //Confirm the feature (to allow it to be selected)
        return true;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">
    private void initComponents() {

        wwpanel = new gov.nasa.worldwind.awt.WorldWindowGLJPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        textbox = new javax.swing.JTextArea();
        opacitySlider = new javax.swing.JSlider();
        selectionCheckbox = new javax.swing.JCheckBox();
        focusButton = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

        org.jdesktop.layout.GroupLayout wwpanelLayout = new org.jdesktop.layout.GroupLayout(wwpanel);
        wwpanel.setLayout(wwpanelLayout);
        wwpanelLayout.setHorizontalGroup(
                wwpanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                .add(0, 690, Short.MAX_VALUE)
                );
        wwpanelLayout.setVerticalGroup(
                wwpanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                .add(0, 471, Short.MAX_VALUE)
                );

        textbox.setColumns(20);
        textbox.setFont(new java.awt.Font("SansSerif", 0, 10));
        textbox.setRows(5);
        jScrollPane1.setViewportView(textbox);

        opacitySlider.setPaintTicks(true);
        opacitySlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                opacitySliderChanged(evt);
            }
        });

        selectionCheckbox.setText("Enable Selection");
        selectionCheckbox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                selectionCheckboxActionPerformed(evt);
            }
        });

        focusButton.setText("Focus Camera");
        focusButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                focusButtonActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
                layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                .add(org.jdesktop.layout.GroupLayout.LEADING, wwpanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(layout.createSequentialGroup()
                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 567, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                .add(opacitySlider, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 117, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(selectionCheckbox)
                .add(focusButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 109, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))))
                .addContainerGap())
                );
        layout.setVerticalGroup(
                layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(wwpanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                .add(layout.createSequentialGroup()
                .add(opacitySlider, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(selectionCheckbox)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(focusButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 39, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 114, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
                );

        pack();
    }// </editor-fold>

private void focusButtonActionPerformed(java.awt.event.ActionEvent evt) {
    WorldWindUtils.flyTo(sf.getSector(), wwpanel);
}

private void selectionCheckboxActionPerformed(java.awt.event.ActionEvent evt) {
    sf.setPickEnabled(this.selectionCheckbox.isSelected());
}

private void opacitySliderChanged(javax.swing.event.ChangeEvent evt) {
    sf.setOpacity((double) opacitySlider.getValue() / (double) opacitySlider.getMaximum());
    wwpanel.redrawNow();
}

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        java.awt.EventQueue.invokeLater(new Runnable() {

            @Override
            public void run() {
                try {
                    new ShapeExample().setVisible(true);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    // Variables declaration - do not modify
    private javax.swing.JButton focusButton;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JSlider opacitySlider;
    private javax.swing.JCheckBox selectionCheckbox;
    private javax.swing.JTextArea textbox;
    private gov.nasa.worldwind.awt.WorldWindowGLJPanel wwpanel;
    // End of variables declaration
}
