/*
 * ShapefileControlPanel.java
 *
 * Created on October 22, 2008, 2:32 PM
 */
package gw.ui.layerproperies;

import gov.nasa.worldwind.WorldWindow;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import gw.api.Events;
import gw.layers.GridCoverageLayer;
import java.awt.event.ItemListener;

/**
 *
 * @author  od
 */
public class GridLayerProperties extends javax.swing.JPanel {

  
//
    GridCoverageLayer layer;
    //Renderable[] labels;

    /** Creates new form ShapefileControlPanel */
    public GridLayerProperties(GridCoverageLayer layer) {
        this.layer = layer;
        initComponents();
        setupComponents(layer);
    }

    private void setupComponents(final GridCoverageLayer layer) {

//        double[] minmax = GeoToolsUtils.getMinMaxHeight(layer.getFeatures(), ww.getModel().getGlobe(), layer.getCRS());
        double[] minmax = {100, 20000};
        
        labelMinMax.setText("[" + Integer.toString((int) minmax[0]) + ", " + Integer.toString((int) minmax[1]) + "]");
        elevationSlider.setValue((int) minmax[1]);
        layer.setElevation((int) minmax[1]);

        surfaceCheck.addItemListener(new ItemListener() {

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean isSel = e.getStateChange() == ItemEvent.SELECTED;
                layer.setFloating(!isSel);
                if (!isSel) {
                    elevationText.setText(Double.toString(elevationSlider.getValue()));
//                    double[] minmax = GeoToolsUtils.getMinMaxHeight(layer.getFeatures(), ww.getModel().getGlobe(), layer.getCRS());
//                    labelMinMax.setText("[" + Integer.toString((int) minmax[0]) + ", " + Integer.toString((int) minmax[1]) + "]");
                }
               
                elevationText.setEnabled(!isSel);
                actualElevationLabel.setEnabled(!isSel);
                labelMinMax.setEnabled(!isSel);
                elevationSlider.setEnabled(!isSel);
                update();
            }
        });

        opacitySlider.setValue((int) (layer.getOpacity() * 100));
        opacitySlider.addChangeListener(new ChangeListener() {

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider slider = (JSlider) e.getSource();
                int value = slider.getValue();
                layer.setOpacity((double) value / 100);
                update();
            }
        });

        elevationText.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                elevationSlider.setValue(Integer.parseInt(elevationText.getText()));
            }
        });

        elevationSlider.addChangeListener(new ChangeListener() {

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider slider = (JSlider) e.getSource();
                int value = slider.getValue();
                layer.setElevation((double) value);
                elevationText.setText(Double.toString(value));
                update();
            }
        });
    }

    private void update() {
        firePropertyChange(Events.GF_UPDATE, null, layer);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel2 = new javax.swing.JLabel();
        opacitySlider = new javax.swing.JSlider();
        surfaceCheck = new javax.swing.JCheckBox();
        actualElevationLabel = new javax.swing.JLabel();
        elevationText = new javax.swing.JTextField();
        labelMinMax = new javax.swing.JLabel();
        elevationSlider = new javax.swing.JSlider();
        jSeparator3 = new javax.swing.JSeparator();

        setLayout(null);

        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("gw/resources/language"); // NOI18N
        jLabel2.setText(bundle.getString("L_Opacity")); // NOI18N
        add(jLabel2);
        jLabel2.setBounds(180, 0, 73, 16);

        opacitySlider.setMajorTickSpacing(25);
        opacitySlider.setMinorTickSpacing(5);
        opacitySlider.setPaintLabels(true);
        opacitySlider.setPaintTicks(true);
        opacitySlider.setPaintTrack(false);
        add(opacitySlider);
        opacitySlider.setBounds(180, 30, 110, 48);

        surfaceCheck.setSelected(true);
        surfaceCheck.setText(bundle.getString("L_Bond_to_Surface")); // NOI18N
        add(surfaceCheck);
        surfaceCheck.setBounds(0, 0, 117, 20);

        actualElevationLabel.setText(bundle.getString("L_Elevation")); // NOI18N
        add(actualElevationLabel);
        actualElevationLabel.setBounds(60, 30, 56, 16);

        elevationText.setText("0");
        elevationText.setEnabled(false);
        add(elevationText);
        elevationText.setBounds(60, 50, 80, 22);

        labelMinMax.setText(bundle.getString("L_Min_Max")); // NOI18N
        add(labelMinMax);
        labelMinMax.setBounds(60, 80, 100, 16);

        elevationSlider.setMajorTickSpacing(2000);
        elevationSlider.setMaximum(20000);
        elevationSlider.setOrientation(javax.swing.JSlider.VERTICAL);
        elevationSlider.setPaintTicks(true);
        elevationSlider.setEnabled(false);
        add(elevationSlider);
        elevationSlider.setBounds(0, 20, 32, 80);

        jSeparator3.setBackground(new java.awt.Color(208, 208, 191));
        jSeparator3.setForeground(new java.awt.Color(236, 233, 216));
        jSeparator3.setOrientation(javax.swing.SwingConstants.VERTICAL);
        jSeparator3.setEnabled(false);
        add(jSeparator3);
        jSeparator3.setBounds(170, 20, 10, 70);
    }// </editor-fold>//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel actualElevationLabel;
    private javax.swing.JSlider elevationSlider;
    private javax.swing.JTextField elevationText;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JSeparator jSeparator3;
    private javax.swing.JLabel labelMinMax;
    private javax.swing.JSlider opacitySlider;
    private javax.swing.JCheckBox surfaceCheck;
    // End of variables declaration//GEN-END:variables
}
