/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * StatisticDialogPanel.java
 *
 * Created on 16.06.2009, 16:00:09
 */

package jams.explorer.gui;

import jams.JAMS;
import java.util.HashMap;
import java.util.Set;
import javax.swing.table.DefaultTableModel;
import jams.explorer.dsproc.DataStatistic;

/**
 *
 * @author hbusch
 */
public class StatisticDialogPanel extends javax.swing.JDialog {
    /** A return status code - returned if Cancel button has been pressed */
    public static final int RET_CANCEL = 0;
    /** A return status code - returned if OK button has been pressed */
    public static final int RET_OK = 1;

    private String[] fieldNames;
    private double[][] data;

    /** Creates new form StatisticDialogPanel */
    public StatisticDialogPanel(java.awt.Frame parent, boolean modal, String[] theFieldNames, double[][] theData) {
        super(parent, modal);
        initComponents();

        this.fieldNames = theFieldNames;
        this.data = theData;

        setupComponents();
    }


    /** @return the return status of this dialog - one of RET_OK or RET_CANCEL */
    public int getReturnStatus() {
        return returnStatus;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        out_Table = new javax.swing.JTable();
        jPanel1 = new javax.swing.JPanel();
        okButton = new javax.swing.JButton();

//        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("reg/resources/JAMSBundle"); // NOI18N
        setTitle(JAMS.i18n("STATISTIK")); // NOI18N
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        out_Table.setColumnSelectionAllowed(true);
        jScrollPane1.setViewportView(out_Table);

        getContentPane().add(jScrollPane1, java.awt.BorderLayout.CENTER);

        okButton.setText(JAMS.i18n("OK")); // NOI18N
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });
        jPanel1.add(okButton);

        getContentPane().add(jPanel1, java.awt.BorderLayout.PAGE_END);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
        doClose(RET_OK);
    }//GEN-LAST:event_okButtonActionPerformed

    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        doClose(RET_CANCEL);
    }//GEN-LAST:event_closeDialog

    private void setupComponents() {

        if (fieldNames == null)
            return;
        int numberOfFields = fieldNames.length;
        String statText = "";
        Object[][] statisticResult = null;
        HashMap<String, Double> oneResult = null;
        String[] header = new String[numberOfFields + 1];
        header[0] = JAMS.i18n("KENNZIFFER");

        String fieldName;
        double[] colData;
        DataStatistic dataStatistic;
        for (int i = 0; i < numberOfFields; i++) {
            fieldName = fieldNames[i];
            colData = data[i];
            header[i+1] = fieldName;
            dataStatistic = new DataStatistic(fieldName, colData);
            oneResult = dataStatistic.getResult();
            if (statisticResult == null) {
                statisticResult = new Object[oneResult.size()][numberOfFields + 1];
            }
            addToResult(oneResult, statisticResult, i + 1);

            statText += dataStatistic.toString();
        }
        out_Table.setModel(
            new DefaultTableModel(statisticResult, header)
        );
    }

    private void addToResult(HashMap<String, Double> oneResult, Object[][] statisticResult, int colNumber) {
        Set<String> keys = oneResult.keySet();
        Double value;
        int i = 0;
        for (String key : keys) {
            value = oneResult.get(key);
            statisticResult[i][0] = key;
            statisticResult[i][colNumber] = value;
            i++;
        }
    }

    private void doClose(int retStatus) {
        returnStatus = retStatus;
        setVisible(false);
        dispose();
    }


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JButton okButton;
    private javax.swing.JTable out_Table;
    // End of variables declaration//GEN-END:variables

    private int returnStatus = RET_CANCEL;
}
