/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.type;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.geotools.feature.type.ProfileImpl;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaImpl
implements Schema {
    HashMap<Name, AttributeType> contents;
    String uri;

    public SchemaImpl(String uri) {
        this.uri = uri;
        this.contents = new HashMap();
    }

    public Set<Name> keySet() {
        return this.contents.keySet();
    }

    public int size() {
        return this.contents.size();
    }

    public boolean isEmpty() {
        return this.contents.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.contents.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.contents.containsValue(value);
    }

    public AttributeType get(Object key) {
        return this.contents.get(key);
    }

    public AttributeType put(Name name, AttributeType type) {
        if (!(name instanceof Name)) {
            throw new IllegalArgumentException("Please use a Name");
        }
        Name n = name;
        if (!n.toString().startsWith(this.uri.toString())) {
            throw new IllegalArgumentException("Provided name was not in schema:" + this.uri);
        }
        if (!(type instanceof AttributeType)) {
            throw new IllegalArgumentException("Please use an AttributeType");
        }
        AttributeType t = type;
        return this.contents.put(n, t);
    }

    public AttributeType remove(Object key) {
        return this.contents.remove(key);
    }

    public void putAll(Map<? extends Name, ? extends AttributeType> t) {
        this.contents.putAll(t);
    }

    public void clear() {
        this.contents.clear();
    }

    public Collection<AttributeType> values() {
        return this.contents.values();
    }

    public Set<Map.Entry<Name, AttributeType>> entrySet() {
        return this.contents.entrySet();
    }

    public int hashCode() {
        return this.contents.hashCode();
    }

    public boolean equals(Object obj) {
        return this.contents.equals(obj);
    }

    public String toString() {
        return this.contents.toString();
    }

    public String getURI() {
        return this.uri;
    }

    public void add(AttributeType type) {
        this.put(type.getName(), type);
    }

    public Schema profile(Set<Name> profile) {
        return new ProfileImpl(this, profile);
    }
}

