/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.crs;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForceCoordinateSystemIterator
implements Iterator<SimpleFeature> {
    protected FeatureIterator<SimpleFeature> reader;
    protected SimpleFeatureType schema;

    ForceCoordinateSystemIterator(FeatureIterator<SimpleFeature> reader, SimpleFeatureType schema) {
        this.reader = reader;
        this.schema = schema;
    }

    public ForceCoordinateSystemIterator(FeatureIterator<SimpleFeature> reader, SimpleFeatureType type, CoordinateReferenceSystem cs) throws SchemaException {
        if (cs == null) {
            throw new NullPointerException("CoordinateSystem required");
        }
        CoordinateReferenceSystem originalCs = type.getGeometryDescriptor().getCoordinateReferenceSystem();
        this.schema = !cs.equals(originalCs) ? FeatureTypes.transform(type, cs) : type;
        this.reader = reader;
    }

    public SimpleFeatureType getFeatureType() {
        if (this.reader == null || this.schema == null) {
            throw new IllegalStateException("Reader has already been closed");
        }
        return this.schema;
    }

    @Override
    public SimpleFeature next() throws NoSuchElementException {
        if (this.reader == null) {
            throw new IllegalStateException("Reader has already been closed");
        }
        SimpleFeature next = this.reader.next();
        if (this.schema == null) {
            return next;
        }
        try {
            return SimpleFeatureBuilder.retype(next, this.schema);
        }
        catch (IllegalAttributeException eep) {
            throw (IllegalStateException)new IllegalStateException(eep.getMessage()).initCause((Throwable)((Object)eep));
        }
    }

    @Override
    public boolean hasNext() {
        if (this.reader == null) {
            throw new IllegalStateException("Reader has already been closed");
        }
        return this.reader.hasNext();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        if (this.reader == null) {
            return;
        }
        this.reader.close();
        this.reader = null;
        this.schema = null;
    }
}

