/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import org.geotools.data.AttributeWriter;
import org.opengis.feature.type.AttributeDescriptor;

public class JoiningAttributeWriter
implements AttributeWriter {
    private AttributeWriter[] writers;
    private int[] index;
    private AttributeDescriptor[] metaData;

    public JoiningAttributeWriter(AttributeWriter[] writers) {
        this.writers = writers;
        this.metaData = this.joinMetaData(writers);
    }

    private AttributeDescriptor[] joinMetaData(AttributeWriter[] writers) {
        int total = 0;
        this.index = new int[writers.length];
        int ii = writers.length;
        for (int i = 0; i < ii; ++i) {
            this.index[i] = total;
            total += writers[i].getAttributeCount();
        }
        AttributeDescriptor[] md = new AttributeDescriptor[total];
        int idx = 0;
        int ii2 = writers.length;
        for (int i = 0; i < ii2; ++i) {
            int jj = writers[i].getAttributeCount();
            for (int j = 0; j < jj; ++j) {
                md[idx] = writers[i].getAttributeType(j);
                ++idx;
            }
        }
        return md;
    }

    public void close() throws IOException {
        IOException dse = null;
        int ii = this.writers.length;
        for (int i = 0; i < ii; ++i) {
            try {
                this.writers[i].close();
                continue;
            }
            catch (IOException e) {
                dse = e;
            }
        }
        if (dse != null) {
            throw dse;
        }
    }

    public boolean hasNext() throws IOException {
        int ii = this.writers.length;
        for (int i = 0; i < ii; ++i) {
            if (!this.writers[i].hasNext()) continue;
            return true;
        }
        return false;
    }

    public void next() throws IOException {
        int ii = this.writers.length;
        for (int i = 0; i < ii; ++i) {
            this.writers[i].next();
        }
    }

    public void write(int position, Object attribute) throws IOException {
        AttributeWriter writer = null;
        for (int i = this.index.length - 1; i >= 0; --i) {
            if (position < this.index[i]) continue;
            position -= this.index[i];
            writer = this.writers[i];
            break;
        }
        if (writer == null) {
            throw new ArrayIndexOutOfBoundsException(position);
        }
        writer.write(position, attribute);
    }

    public int getAttributeCount() {
        return this.metaData.length;
    }

    public AttributeDescriptor getAttributeType(int i) {
        return this.metaData[i];
    }
}

