/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataStore;
import org.geotools.data.FileDataStoreFactorySpi;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.util.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileDataStoreFinder {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data");

    private FileDataStoreFinder() {
    }

    public static DataStore getDataStore(URL url) throws IOException {
        Iterator<FileDataStoreFactorySpi> ps = FileDataStoreFinder.getAvailableDataStores();
        while (ps.hasNext()) {
            FileDataStoreFactorySpi fac = ps.next();
            try {
                if (!fac.canProcess(url)) continue;
                return fac.createDataStore(url);
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Could not aquire " + fac.getDescription() + ":" + t, t);
            }
        }
        return null;
    }

    public static Iterator<FileDataStoreFactorySpi> getAvailableDataStores() {
        HashSet<FileDataStoreFactorySpi> availableDS = new HashSet<FileDataStoreFactorySpi>();
        Set all = CommonFactoryFinder.getFileDataStoreFactories(null);
        for (FileDataStoreFactorySpi dsFactory : all) {
            if (!dsFactory.isAvailable()) continue;
            availableDS.add(dsFactory);
        }
        return availableDS.iterator();
    }

    public static Set<String> getAvailableFileExtentions() {
        HashSet<String> extentions = new HashSet<String>();
        Iterator<FileDataStoreFactorySpi> ps = FileDataStoreFinder.getAvailableDataStores();
        while (ps.hasNext()) {
            FileDataStoreFactorySpi fac = ps.next();
            try {
                for (String fileExtention : fac.getFileExtensions()) {
                    extentions.add(fileExtention);
                }
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Could not aquire " + fac.getDescription() + ":" + t, t);
            }
        }
        return extentions;
    }
}

