/*
 * Decompiled with CFR 0.152.
 */
package oms3.compiler;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import oms3.compiler.JavaFileManagerClassLoader;
import oms3.compiler.MemoryOutputJavaFileManager;
import oms3.compiler.MemorySourceJavaFileObject;

public final class Compiler {
    JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
    MemoryOutputJavaFileManager fileManager;
    ClassLoader loader;
    Map<String, Class<?>> cache = new HashMap();
    List<String> compilerOptions = new ArrayList<String>();
    private static Compiler instance;

    public static synchronized Compiler singleton(URLClassLoader parent) {
        if (instance == null) {
            instance = new Compiler(parent);
        }
        return instance;
    }

    private Compiler(URLClassLoader parent) {
        if (this.compiler == null) {
            throw new Error("Compiler not available.  This may happen if running on JRE instead of JDK.  Please use a full JDK 1.6.javax.tools.ToolProvider.getSystemJavaCompiler() returned null.");
        }
        this.fileManager = new MemoryOutputJavaFileManager(this.compiler.getStandardFileManager(null, null, null));
        this.loader = new JavaFileManagerClassLoader(this.fileManager, (ClassLoader)parent);
        StringBuilder b = new StringBuilder();
        URL[] cp = parent.getURLs();
        for (int i = 0; i < cp.length; ++i) {
            b.append(File.pathSeparatorChar);
            b.append(cp[i].getFile());
        }
        this.compilerOptions.addAll(Arrays.asList("-cp", System.getProperty("java.class.path") + b.toString()));
    }

    public synchronized Class<?> compileSource(String name, String code) throws Exception {
        Class<?> c = this.cache.get(name);
        if (c == null) {
            c = this.compileSource0(name, code);
            this.cache.put(name, c);
        }
        return c;
    }

    public synchronized Class<?> getCompiledClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            try {
                return this.loader.loadClass(name);
            }
            catch (ClassNotFoundException ex) {
                return this.cache.get(name);
            }
        }
    }

    private Class<?> compileSource0(String className, String sourceCode) throws Exception {
        ArrayList<MemorySourceJavaFileObject> compUnits = new ArrayList<MemorySourceJavaFileObject>(1);
        compUnits.add(new MemorySourceJavaFileObject(className + ".java", sourceCode));
        DiagnosticCollector diag = new DiagnosticCollector();
        Boolean result = this.compiler.getTask(null, this.fileManager, diag, this.compilerOptions, null, compUnits).call();
        if (result.equals(Boolean.FALSE)) {
            throw new RuntimeException(diag.getDiagnostics().toString());
        }
        String classDotName = className.replace('/', '.');
        return Class.forName(classDotName, true, this.loader);
    }
}

