/*
 * Decompiled with CFR 0.152.
 */
package oms3;

import java.lang.reflect.Field;
import oms3.Access;
import oms3.ComponentException;
import oms3.FieldContent;
import oms3.Notification;

class FieldObjectAccess
implements Access {
    Notification ens;
    FieldContent.FA data;
    Access fa;

    FieldObjectAccess(Access fa, FieldContent.FA data, Notification ens) {
        this.fa = fa;
        this.data = data;
        this.ens = ens;
    }

    @Override
    public boolean isValid() {
        return this.data != null;
    }

    @Override
    public void in() throws Exception {
        if (this.data == null) {
            throw new ComponentException("Not connected: " + this.toString());
        }
        Object val = this.data.getFieldValue();
        if (this.ens.shouldFire()) {
            Notification.DataflowEvent e = new Notification.DataflowEvent(this.ens.getController(), this, val);
            this.ens.fireIn(e);
            val = e.getValue();
        }
        this.fa.setFieldValue(val);
    }

    @Override
    public void out() throws Exception {
        Object val = this.fa.getFieldValue();
        if (this.ens.shouldFire()) {
            Notification.DataflowEvent e = new Notification.DataflowEvent(this.ens.getController(), this, val);
            this.ens.fireOut(e);
            val = e.getValue();
        }
        if (this.data != null) {
            this.data.setFieldValue(val);
        }
        this.fa.out();
    }

    @Override
    public Object getComponent() {
        return this.fa.getComponent();
    }

    @Override
    public Field getField() {
        return this.fa.getField();
    }

    public String toString() {
        return "FieldObjectAccess [" + this.fa.toString() + " - " + this.data;
    }

    @Override
    public Object getFieldValue() throws Exception {
        return this.fa.getFieldValue();
    }

    @Override
    public void setFieldValue(Object o) throws Exception {
        this.fa.setFieldValue(o);
    }

    @Override
    public FieldContent getData() {
        return this.fa.getData();
    }

    @Override
    public void setData(FieldContent data) {
        this.fa.setData(data);
    }
}

