/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.IOException;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.image.ImageTiler;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.RandomAccess;

public class ImageData
extends Data {
    long byteSize;
    Object dataArray;
    ArrayDesc dataDescription;
    private ImageTiler tiler;

    public ImageData(Header header) throws FitsException {
        this.dataDescription = this.parseHeader(header);
    }

    protected ArrayDesc parseHeader(Header header) throws FitsException {
        Class<Number> clazz;
        int n = header.getIntValue("GCOUNT", 1);
        int n2 = header.getIntValue("PCOUNT", 0);
        if (n > 1 || n2 != 0) {
            throw new FitsException("Group data treated as images");
        }
        int n3 = header.getIntValue("BITPIX", 0);
        if (n3 == 8) {
            clazz = Byte.TYPE;
        } else if (n3 == 16) {
            clazz = Short.TYPE;
        } else if (n3 == 32) {
            clazz = Integer.TYPE;
        } else if (n3 == 64) {
            clazz = Long.TYPE;
        } else if (n3 == -32) {
            clazz = Float.TYPE;
        } else if (n3 == -64) {
            clazz = Double.TYPE;
        } else {
            throw new FitsException("Invalid BITPIX:" + n3);
        }
        int n4 = header.getIntValue("NAXIS", 0);
        int[] nArray = new int[n4];
        this.byteSize = 1L;
        int n5 = 0;
        while (n5 < n4) {
            int n6 = header.getIntValue("NAXIS" + (n5 + 1), 0);
            if (n6 < 0) {
                throw new FitsException("Invalid array dimension:" + n6);
            }
            this.byteSize *= (long)n6;
            nArray[n4 - n5 - 1] = n6;
            ++n5;
        }
        this.byteSize *= (long)(Math.abs(n3) / 8);
        if (n4 == 0) {
            this.byteSize = 0L;
        }
        return new ArrayDesc(nArray, clazz);
    }

    public ImageData() {
        this.dataArray = new byte[0];
        this.byteSize = 0L;
    }

    public ImageData(Object object) {
        this.dataArray = object;
        this.byteSize = ArrayFuncs.computeSize(object);
    }

    protected void fillHeader(Header header) throws FitsException {
        int n;
        if (this.dataArray == null) {
            header.nullImage();
            return;
        }
        String string = this.dataArray.getClass().getName();
        int[] nArray = ArrayFuncs.getDimensions(this.dataArray);
        if (nArray == null || nArray.length == 0) {
            throw new FitsException("Image data object not array");
        }
        switch (string.charAt(nArray.length)) {
            case 'B': {
                n = 8;
                break;
            }
            case 'S': {
                n = 16;
                break;
            }
            case 'I': {
                n = 32;
                break;
            }
            case 'J': {
                n = 64;
                break;
            }
            case 'F': {
                n = -32;
                break;
            }
            case 'D': {
                n = -64;
                break;
            }
            default: {
                throw new FitsException("Invalid Object Type for FITS data:" + string.charAt(nArray.length));
            }
        }
        header.setSimple(true);
        header.setBitpix(n);
        header.setNaxes(nArray.length);
        int n2 = 1;
        while (n2 <= nArray.length) {
            if (nArray[n2 - 1] == -1) {
                throw new FitsException("Unfilled array for dimension: " + n2);
            }
            header.setNaxis(n2, nArray[nArray.length - n2]);
            ++n2;
        }
        header.addValue("PCOUNT", 0L, "No extra parameters");
        header.addValue("GCOUNT", 1L, "One group");
        header.addValue("EXTEND", true, "Extensions are permitted");
    }

    public void read(ArrayDataInput arrayDataInput) throws FitsException {
        if (this.byteSize == 0L) {
            return;
        }
        this.setFileOffset(arrayDataInput);
        if (arrayDataInput instanceof RandomAccess) {
            this.tiler = new ImageDataTiler((RandomAccess)arrayDataInput, ((RandomAccess)arrayDataInput).getFilePointer(), this.dataDescription);
            try {
                arrayDataInput.skipBytes((int)this.byteSize);
            }
            catch (IOException iOException) {
                throw new FitsException("Unable to skip over data:" + iOException);
            }
        }
        this.dataArray = ArrayFuncs.newInstance(this.dataDescription.type, this.dataDescription.dims);
        try {
            arrayDataInput.readArray(this.dataArray);
        }
        catch (IOException iOException) {
            throw new FitsException("Unable to read image data:" + iOException);
        }
        this.tiler = new ImageDataTiler(null, 0L, this.dataDescription);
        int n = FitsUtil.padding(this.getTrueSize());
        try {
            if (arrayDataInput.skipBytes(n) != n) {
                throw new FitsException("Error skipping padding");
            }
        }
        catch (IOException iOException) {
            throw new FitsException("Error reading image padding:" + iOException);
        }
    }

    public void write(ArrayDataOutput arrayDataOutput) throws FitsException {
        if (this.byteSize == 0L) {
            return;
        }
        if (this.dataArray == null && this.tiler != null) {
            try {
                this.dataArray = this.tiler.getCompleteImage();
            }
            catch (IOException iOException) {
                throw new FitsException("Error attempting to fill image");
            }
        }
        if (this.dataArray == null) {
            throw new FitsException("Null image data");
        }
        try {
            arrayDataOutput.writeArray(this.dataArray);
        }
        catch (IOException iOException) {
            throw new FitsException("IO Error on image write" + iOException);
        }
        byte[] byArray = new byte[FitsUtil.padding(this.getTrueSize())];
        try {
            arrayDataOutput.write(byArray);
            arrayDataOutput.flush();
        }
        catch (IOException iOException) {
            throw new FitsException("Error writing padding: " + iOException);
        }
    }

    protected int getTrueSize() {
        return (int)this.byteSize;
    }

    public Object getData() {
        if (this.dataArray == null && this.tiler != null) {
            try {
                this.dataArray = this.tiler.getCompleteImage();
            }
            catch (Exception exception) {
                return null;
            }
        }
        return this.dataArray;
    }

    public ImageTiler getTiler() {
        return this.tiler;
    }

    protected class ImageDataTiler
    extends ImageTiler {
        ImageDataTiler(RandomAccess randomAccess, long l, ArrayDesc arrayDesc) {
            super(randomAccess, l, arrayDesc.dims, arrayDesc.type);
        }

        public Object getMemoryImage() {
            return ImageData.this.dataArray;
        }
    }

    protected class ArrayDesc {
        int[] dims;
        Class type;

        ArrayDesc(int[] nArray, Class clazz) {
            this.dims = nArray;
            this.type = clazz;
        }
    }
}

