/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import nom.tam.fits.FitsFactory;
import nom.tam.fits.HeaderCardException;

public class HeaderCard {
    private String key;
    private String value;
    private String comment;
    private boolean isString;
    public static final int MAX_KEYWORD_LENGTH = 8;
    public static final int MAX_VALUE_LENGTH = 70;
    private static String space80 = "                                                                                ";

    public HeaderCard(String string, double d, String string2) throws HeaderCardException {
        this(string, String.valueOf(d), string2);
        this.isString = false;
    }

    public HeaderCard(String string, boolean bl, String string2) throws HeaderCardException {
        this(string, bl ? "T" : "F", string2);
        this.isString = false;
    }

    public HeaderCard(String string, int n, String string2) throws HeaderCardException {
        this(string, String.valueOf(n), string2);
        this.isString = false;
    }

    public HeaderCard(String string, long l, String string2) throws HeaderCardException {
        this(string, String.valueOf(l), string2);
        this.isString = false;
    }

    public HeaderCard(String string, String string2, String string3) throws HeaderCardException {
        if (string == null && string2 != null) {
            throw new HeaderCardException("Null keyword with non-null value");
        }
        if (!(string == null || string.length() <= 8 || FitsFactory.getUseHierarch() && string.substring(0, 9).equals("HIERARCH."))) {
            throw new HeaderCardException("Keyword too long");
        }
        if (string2 != null) {
            if ((string2 = string2.trim()).length() > 70) {
                throw new HeaderCardException("Value too long");
            }
            if (string2.charAt(0) == '\'') {
                if (string2.charAt(string2.length() - 1) != '\'') {
                    throw new HeaderCardException("Missing end quote in string value");
                }
                string2 = string2.substring(1, string2.length() - 1).trim();
            }
        }
        this.key = string;
        this.value = string2;
        this.comment = string3;
        this.isString = true;
    }

    public HeaderCard(String string) {
        this.key = null;
        this.value = null;
        this.comment = null;
        this.isString = false;
        if (FitsFactory.getUseHierarch() && string.length() > 9 && string.substring(0, 9).equals("HIERARCH ")) {
            this.hierarchCard(string);
            return;
        }
        if (string.length() < 9) {
            this.key = string;
            return;
        }
        this.key = string.substring(0, 8).trim();
        if (this.key.length() == 0) {
            this.key = "";
            this.comment = string.substring(8);
            return;
        }
        if (!string.substring(8, 10).equals("= ")) {
            this.comment = string.substring(8).trim();
            return;
        }
        String string2 = string.substring(10).trim();
        if (string2.length() == 0) {
            this.value = "";
            return;
        }
        int n = -1;
        boolean bl = false;
        if (string2.charAt(0) == '\'') {
            int n2 = 1;
            while (n2 < string2.length()) {
                n = string2.indexOf("'", n2);
                if (n == string2.length() - 1) break;
                if (n == -1) {
                    this.key = null;
                    this.comment = string;
                    return;
                }
                if (string2.charAt(n + 1) != '\'') break;
                n2 = n + 2;
            }
            this.value = string2.substring(1, n).trim();
            if (n + 1 >= string2.length()) {
                this.comment = null;
            } else {
                this.comment = string2.substring(n + 1).trim();
                if (this.comment.charAt(0) == '/') {
                    this.comment = this.comment.length() > 1 ? this.comment.substring(1) : "";
                }
                if (this.comment.length() == 0) {
                    this.comment = null;
                }
            }
            this.isString = true;
        } else {
            int n3 = string2.indexOf(47);
            if (n3 != -1) {
                this.comment = string2.substring(n3 + 1).trim();
                this.value = string2.substring(0, n3).trim();
            } else {
                this.value = string2;
            }
        }
    }

    private void hierarchCard(String string) {
        int[] nArray;
        String string2 = "";
        String string3 = null;
        String string4 = "";
        int n = 0;
        int n2 = -1;
        while ((nArray = this.getToken(string, n)) != null) {
            string3 = string.substring(nArray[0], nArray[1]);
            if (string3.equals("=")) {
                if ((nArray = this.getToken(string, nArray[1])) != null) {
                    string3 = string.substring(nArray[0], nArray[1]);
                    break;
                }
                this.key = string2;
                this.value = null;
                this.comment = null;
                return;
            }
            string2 = string2 + string4 + string3;
            string4 = ".";
            n = nArray[1];
        }
        this.key = string2;
        if (nArray == null) {
            this.value = null;
            this.comment = null;
            this.isString = false;
            return;
        }
        if (string3.charAt(0) == '\'') {
            int n3;
            this.isString = true;
            if (string3.length() > 1 && string3.charAt(1) == '\'' && (string3.length() == 2 || string3.charAt(2) != '\'')) {
                this.value = "";
                n2 = nArray[0] + 2;
            } else {
                if (string.length() < nArray[0] + 2) {
                    this.value = null;
                    this.comment = null;
                    this.isString = false;
                    return;
                }
                n3 = nArray[0] + 1;
                while (n3 < string.length()) {
                    if (string.charAt(n3) == '\'') {
                        if (n3 == string.length() - 1) {
                            this.value = string.substring(nArray[0] + 1, n3);
                            n2 = n3 + 1;
                            break;
                        }
                        if (string.charAt(n3 + 1) == '\'') {
                            ++n3;
                        } else {
                            this.value = string.substring(nArray[0] + 1, n3);
                            n2 = n3 + 1;
                            break;
                        }
                    }
                    ++n3;
                }
            }
            if (n2 < 0) {
                this.value = null;
                this.comment = null;
                this.isString = false;
                return;
            }
            n3 = n2;
            while (n3 < string.length()) {
                if (string.charAt(n3) == '/') {
                    this.comment = string.substring(n3 + 1).trim();
                    break;
                }
                if (string.charAt(n3) != ' ') {
                    this.comment = null;
                    break;
                }
                ++n3;
            }
        } else {
            this.isString = false;
            int n4 = string3.indexOf(47);
            if (n4 == 0) {
                this.value = null;
                this.comment = string.substring(nArray[0] + 1);
            } else if (n4 > 0) {
                this.value = string3.substring(0, n4);
                this.comment = string.substring(nArray[0] + n4 + 1);
            } else {
                this.value = string3;
                int n5 = nArray[1];
                while (n5 < string.length()) {
                    if (string.charAt(n5) == '/') {
                        this.comment = string.substring(n5 + 1).trim();
                        break;
                    }
                    if (string.charAt(n5) != ' ') {
                        this.comment = null;
                        break;
                    }
                    ++n5;
                }
            }
        }
    }

    private int[] getToken(String string, int n) {
        int n2 = n;
        while (n2 < string.length()) {
            if (string.charAt(n2) != ' ') break;
            ++n2;
        }
        if (n2 >= string.length()) {
            return null;
        }
        if (string.charAt(n2) == '=') {
            return new int[]{n2, n2 + 1};
        }
        int n3 = n2 + 1;
        while (n3 < string.length()) {
            if (string.charAt(n3) == ' ' || string.charAt(n3) == '=') break;
            ++n3;
        }
        return new int[]{n2, n3};
    }

    public boolean isStringValue() {
        return this.isString;
    }

    public boolean isKeyValuePair() {
        return this.key != null && this.value != null;
    }

    void setKey(String string) {
        this.key = string;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public String getComment() {
        return this.comment;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(80);
        if (this.key != null) {
            if (this.key.length() > 9 && this.key.substring(0, 9).equals("HIERARCH.")) {
                return this.hierarchToString();
            }
            stringBuffer.append(this.key);
            if (this.key.length() < 8) {
                stringBuffer.append(space80.substring(0, 8 - stringBuffer.length()));
            }
        }
        if (this.value != null) {
            stringBuffer.append("= ");
            if (this.isString) {
                stringBuffer.append('\'');
                stringBuffer.append(this.value);
                if (stringBuffer.length() < 19) {
                    stringBuffer.append(space80.substring(0, 19 - stringBuffer.length()));
                }
                stringBuffer.append('\'');
                if (stringBuffer.length() < 30) {
                    stringBuffer.append(space80.substring(0, 30 - stringBuffer.length()));
                }
            } else {
                int n = stringBuffer.length();
                if (this.value.length() < 20) {
                    stringBuffer.append(space80.substring(0, 20 - this.value.length()));
                }
                stringBuffer.append(this.value);
            }
            if (this.comment != null) {
                stringBuffer.append(" / ");
            }
        } else if (this.comment != null && this.comment.startsWith("= ")) {
            stringBuffer.append("  ");
        }
        if (this.comment != null) {
            stringBuffer.append(this.comment);
        }
        if (stringBuffer.length() > 80) {
            stringBuffer.setLength(80);
        } else if (stringBuffer.length() < 80) {
            stringBuffer.append(space80.substring(0, 80 - stringBuffer.length()));
        }
        return stringBuffer.toString();
    }

    private String hierarchToString() {
        String string;
        int n;
        StringBuffer stringBuffer = new StringBuffer(80);
        int n2 = 0;
        String string2 = "";
        while (n2 < this.key.length()) {
            n = this.key.indexOf(46, n2);
            if (n < 0) {
                stringBuffer.append(string2 + this.key.substring(n2));
                break;
            }
            stringBuffer.append(string2 + this.key.substring(n2, n));
            string2 = " ";
            n2 = n + 1;
        }
        if (this.value != null) {
            n = 78 - (stringBuffer.length() + this.value.length());
            if (this.isString) {
                n -= 2;
            }
            if (this.comment != null) {
                n -= 3 + this.comment.length();
            }
            if (n > 0 && stringBuffer.length() < 29) {
                stringBuffer.append(space80.substring(0, Math.min(n, 29 - stringBuffer.length())));
            }
            stringBuffer.append("= ");
            if (this.isString) {
                stringBuffer.append('\'');
            } else if (n > 0 && this.value.length() < 10) {
                stringBuffer.append(space80.substring(0, Math.min(n, 10 - this.value.length())));
            }
            stringBuffer.append(this.value);
            if (this.isString) {
                stringBuffer.append('\'');
            }
        }
        if (this.comment != null) {
            stringBuffer.append(" / " + this.comment);
        }
        if (stringBuffer.length() < 80) {
            stringBuffer.append(space80.substring(0, 80 - stringBuffer.length()));
        }
        if ((string = new String(stringBuffer)).length() > 80) {
            string = string.substring(0, 80);
        }
        return string;
    }
}

