/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import nom.tam.fits.BinaryTable;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.TableData;
import nom.tam.fits.TableHDU;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.ColumnTable;

public class BinaryTableHDU
extends TableHDU {
    private BinaryTable table;

    public BinaryTableHDU(Header header, Data data) {
        super((TableData)((Object)data));
        this.myHeader = header;
        this.myData = data;
        this.table = (BinaryTable)data;
    }

    public static Data manufactureData(Header header) throws FitsException {
        return new BinaryTable(header);
    }

    public Data manufactureData() throws FitsException {
        return BinaryTableHDU.manufactureData(this.myHeader);
    }

    public static Header manufactureHeader(Data data) throws FitsException {
        Header header = new Header();
        data.fillHeader(header);
        return header;
    }

    public static Data encapsulate(Object object) throws FitsException {
        if (object instanceof ColumnTable) {
            return new BinaryTable((ColumnTable)object);
        }
        if (object instanceof Object[][]) {
            return new BinaryTable((Object[][])object);
        }
        if (object instanceof Object[]) {
            return new BinaryTable((Object[])object);
        }
        throw new FitsException("Unable to encapsulate object of type:" + object.getClass().getName() + " as BinaryTable");
    }

    public static boolean isHeader(Header header) {
        String string = header.getStringValue("XTENSION");
        if (string == null) {
            return false;
        }
        return (string = string.trim()).equals("BINTABLE") || string.equals("A3DTABLE");
    }

    public boolean isHeader() {
        return BinaryTableHDU.isHeader(this.myHeader);
    }

    public static boolean isData(Object object) {
        return object instanceof ColumnTable || object instanceof Object[][] || object instanceof Object[];
    }

    public int addColumn(Object object) throws FitsException {
        int n = this.table.addColumn(object);
        this.table.pointToColumn(this.getNCols() - 1, this.myHeader);
        return n;
    }

    public void write(ArrayDataOutput arrayDataOutput) throws FitsException {
        int n = this.myHeader.getIntValue("PCOUNT");
        if (n != this.table.getHeapSize()) {
            this.myHeader.addValue("PCOUNT", this.table.getHeapSize(), "Includes Heap");
        }
        if (this.myHeader.getIntValue("PCOUNT") == 0) {
            this.myHeader.deleteKey("THEAP");
        } else {
            this.myHeader.getIntValue("TFIELDS");
            int n2 = this.myHeader.getIntValue("NAXIS1") * this.myHeader.getIntValue("NAXIS2") + this.table.getHeapOffset();
            this.myHeader.addValue("THEAP", n2, "");
        }
        super.write(arrayDataOutput);
    }

    public void info() {
        BinaryTable binaryTable = (BinaryTable)this.myData;
        System.out.println("  Binary Table");
        System.out.println("      Header Information:");
        int n = this.myHeader.getIntValue("TFIELDS", -1);
        int n2 = this.myHeader.getIntValue("NAXIS2", -1);
        int n3 = this.myHeader.getIntValue("NAXIS1", -1);
        System.out.print("          " + n + " fields");
        System.out.println(", " + n2 + " rows of length " + n3);
        int n4 = 1;
        while (n4 <= n) {
            System.out.print("           " + n4 + ":");
            this.checkField("TTYPE" + n4);
            this.checkField("TFORM" + n4);
            this.checkField("TDIM" + n4);
            System.out.println(" ");
            ++n4;
        }
        System.out.println("      Data Information:");
        if (binaryTable == null || this.table.getNRows() == 0 || this.table.getNCols() == 0) {
            System.out.println("         No data present");
            if (this.table.getHeapSize() > 0) {
                System.out.println("         Heap size is: " + this.table.getHeapSize() + " bytes");
            }
        } else {
            System.out.println("          Number of rows=" + this.table.getNRows());
            System.out.println("          Number of columns=" + this.table.getNCols());
            if (this.table.getHeapSize() > 0) {
                System.out.println("          Heap size is: " + this.table.getHeapSize() + " bytes");
            }
            Object[] objectArray = this.table.getFlatColumns();
            int n5 = 0;
            while (n5 < objectArray.length) {
                System.out.println("           " + n5 + ":" + ArrayFuncs.arrayDescription(objectArray[n5]));
                ++n5;
            }
        }
    }
}

