/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import nom.tam.fits.AsciiTable;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCardException;
import nom.tam.fits.TableData;
import nom.tam.fits.TableHDU;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.Cursor;

public class AsciiTableHDU
extends TableHDU {
    AsciiTable data;

    public AsciiTableHDU(Header header, Data data) {
        super((TableData)((Object)data));
        this.myHeader = header;
        this.data = (AsciiTable)data;
        this.myData = data;
    }

    public static boolean isHeader(Header header) {
        return header.getStringValue("XTENSION").trim().equals("TABLE");
    }

    public boolean isHeader() {
        return AsciiTableHDU.isHeader(this.myHeader);
    }

    public static boolean isData(Object object) {
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n = 0;
            while (n < objectArray.length) {
                if (!(objectArray[n] instanceof String[] || objectArray[n] instanceof int[] || objectArray[n] instanceof long[] || objectArray[n] instanceof float[] || objectArray[n] instanceof double[])) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public static Data manufactureData(Header header) throws FitsException {
        return new AsciiTable(header);
    }

    public Data manufactureData() throws FitsException {
        return AsciiTableHDU.manufactureData(this.myHeader);
    }

    public static Header manufactureHeader(Data data) throws FitsException {
        Header header = new Header();
        data.fillHeader(header);
        Cursor cursor = header.iterator();
        return header;
    }

    public static Data encapsulate(Object object) throws FitsException {
        Object[] objectArray = (Object[])object;
        AsciiTable asciiTable = new AsciiTable();
        int n = 0;
        while (n < objectArray.length) {
            asciiTable.addColumn(objectArray[n]);
            ++n;
        }
        return asciiTable;
    }

    public void readData(ArrayDataInput arrayDataInput) throws FitsException {
        this.myData.read(arrayDataInput);
    }

    public void setNull(int n, int n2, boolean bl) {
        String string;
        if (bl && (string = this.myHeader.getStringValue("TNULL" + (n2 + 1))) == null) {
            this.setNullString(n2, "NULL");
        }
        this.data.setNull(n, n2, bl);
    }

    public boolean isNull(int n, int n2) {
        return this.data.isNull(n, n2);
    }

    public void setNullString(int n, String string) {
        this.myHeader.positionAfterIndex("TBCOL", n + 1);
        try {
            this.myHeader.addValue("TNULL" + (n + 1), string, null);
        }
        catch (HeaderCardException headerCardException) {
            System.err.println("Impossible exception in setNullString" + headerCardException);
        }
        this.data.setNullString(n, string);
    }

    public int addColumn(Object object) throws FitsException {
        this.data.addColumn(object);
        Cursor cursor = this.myHeader.positionAfterIndex("TBCOL", this.data.getNCols());
        int n = this.data.addColInfo(this.getNCols(), cursor);
        int n2 = this.myHeader.getIntValue("NAXIS1");
        this.myHeader.setNaxis(1, n + n2);
        int n3 = this.myHeader.getIntValue("TFIELDS");
        try {
            this.myHeader.addValue("TFIELDS", n3 + 1, (String)null);
        }
        catch (Exception exception) {
            System.err.println("Impossible exception at addColumn:" + exception);
        }
        return this.getNCols();
    }

    public void info() {
        System.out.println("ASCII Table:");
        System.out.println("  Header:");
        System.out.println("    Number of fields:" + this.myHeader.getIntValue("TFIELDS"));
        System.out.println("    Number of rows:  " + this.myHeader.getIntValue("NAXIS2"));
        System.out.println("    Length of row:   " + this.myHeader.getIntValue("NAXIS1"));
        System.out.println("  Data:");
        Object[] objectArray = (Object[])this.getKernel();
        int n = 0;
        while (n < this.getNCols()) {
            System.out.println("      " + n + ":" + ArrayFuncs.arrayDescription(objectArray[n]));
            ++n;
        }
    }

    public Data getData() {
        return this.data;
    }
}

