/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.hdflib;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import ncsa.hdf.hdflib.HDFException;
import ncsa.hdf.hdflib.HDFJavaException;

class TabDescriptor {
    String theType = "";
    Class theClass = null;
    int nfields;
    int totalsize = 0;
    Field[] flds;
    String[] fldTypeName;
    Class[] fldType;
    int[] fldLen;
    Object[] theFields;

    TabDescriptor(Object theStruct) throws HDFException, IllegalAccessException {
        this.theClass = theStruct.getClass();
        this.theType = this.theClass.toString();
        int i = 0;
        this.flds = this.theClass.getFields();
        this.nfields = Array.getLength(this.flds);
        this.fldType = new Class[this.nfields];
        this.fldTypeName = new String[this.nfields];
        this.fldLen = new int[this.nfields];
        this.theFields = new Object[this.nfields];
        for (i = 0; i < this.nfields; ++i) {
            this.fldType[i] = this.flds[i].getType();
            this.fldTypeName[i] = this.fldType[i].getName();
            this.theFields[i] = this.flds[i].get(theStruct);
            if (this.theFields[i] == null) {
                HDFJavaException ex = new HDFJavaException("HDFTable: Field not defined: " + this.flds[i].getName());
                throw ex;
            }
            this.fldLen[i] = this.calcsize(this.fldType[i], this.flds[i].get(theStruct));
            this.totalsize += this.fldLen[i];
        }
    }

    int calcsize(Class type, Object obj) throws HDFException {
        String s = type.toString();
        if (s.equals("int")) {
            return 4;
        }
        if (s.equals("byte")) {
            return 1;
        }
        if (s.equals("short")) {
            return 2;
        }
        if (s.equals("float")) {
            return 4;
        }
        if (s.equals("long")) {
            return 8;
        }
        if (s.equals("double")) {
            return 16;
        }
        if (s.equals("class java.lang.String")) {
            return ((String)obj).length();
        }
        if (s.startsWith("class [")) {
            if (!obj.getClass().isArray()) {
                System.out.println("Error:  byteify requires array");
                return -1;
            }
            int dims = 0;
            int c = 32;
            for (int n = 6; n < s.length(); ++n) {
                c = s.charAt(n);
                if (c != 91) continue;
                ++dims;
            }
            int NT = c;
            int NTsize = 0;
            if (NT == 66) {
                NTsize = 1;
            } else if (NT == 83) {
                NTsize = 2;
            } else if (NT == 73 || NT == 70) {
                NTsize = 4;
            } else if (NT == 74 || NT == 68) {
                NTsize = 8;
            } else {
                System.out.println("Error:  array is not numeric?");
                HDFJavaException ex = new HDFJavaException("HDFTable: Array is not numeric?: " + s);
                throw ex;
            }
            Object o = obj;
            int dimlen = 1;
            int size = NTsize;
            for (int i = 1; i <= dims; ++i) {
                dimlen = Array.getLength(o);
                size *= dimlen;
                o = Array.get(o, 0);
            }
            return size;
        }
        HDFJavaException ex = new HDFJavaException("HDFTable: Unsupported data type: " + s);
        throw ex;
    }
}

