/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.performance;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Polygon;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.util.ArrayList;

public class PolygonsEverywhere
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Very Many Polygons", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            super(true, true, false);
            this.makeMany();
        }

        protected void makeMany() {
            int n = 0;
            double d = -50.0;
            double d2 = 50.0;
            double d3 = -140.0;
            double d4 = -10.0;
            double d5 = 1.5;
            double d6 = 5.0;
            double d7 = 1.0 / d6;
            double d8 = 1.0 / d6;
            ArrayList<Position> arrayList = new ArrayList<Position>();
            RenderableLayer renderableLayer = new RenderableLayer();
            renderableLayer.setPickEnabled(false);
            int n2 = 0;
            for (double d9 = d; d9 <= d2; d9 += d5) {
                for (double d10 = d3; d10 <= d4; d10 += d5) {
                    arrayList.clear();
                    double d11 = d9;
                    double d12 = d10;
                    int n3 = 0;
                    while ((double)n3 <= d6) {
                        arrayList.add(Position.fromDegrees(d11, d12 += d8, 50000.0));
                        ++n3;
                    }
                    n3 = 0;
                    while ((double)n3 <= d6) {
                        arrayList.add(Position.fromDegrees(d11 += d7, d12, 50000.0));
                        ++n3;
                    }
                    n3 = 0;
                    while ((double)n3 <= d6) {
                        arrayList.add(Position.fromDegrees(d11, d12 -= d8, 50000.0));
                        ++n3;
                    }
                    n3 = 0;
                    while ((double)n3 <= d6) {
                        arrayList.add(Position.fromDegrees(d11 -= d7, d12, 50000.0));
                        ++n3;
                    }
                    Polygon polygon = new Polygon(arrayList);
                    polygon.setAltitudeMode(n);
                    BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
                    basicShapeAttributes.setDrawOutline(false);
                    basicShapeAttributes.setInteriorMaterial(Material.RED);
                    basicShapeAttributes.setEnableLighting(true);
                    polygon.setAttributes(basicShapeAttributes);
                    renderableLayer.addRenderable(polygon);
                    ++n2;
                }
            }
            System.out.printf("%d Polygons, %d positions each, Altitude mode = %s\n", n2, arrayList.size(), n == 2 ? "RELATIVE_TO_GROUND" : "ABSOLUTE");
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), renderableLayer);
            this.getLayerPanel().update(this.getWwd());
        }
    }
}

