/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.performance;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.PointPlacemark;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.util.ArrayList;

public class PointPlacemarksEverywhere
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Very Many Point Placemarks", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            super(true, true, false);
            this.makeMany();
        }

        protected void makeMany() {
            int n = 2;
            double d = -50.0;
            double d2 = 50.0;
            double d3 = -140.0;
            double d4 = -10.0;
            double d5 = 1.5;
            double d6 = 5.0;
            ArrayList arrayList = new ArrayList();
            RenderableLayer renderableLayer = new RenderableLayer();
            int n2 = 0;
            for (double d7 = d; d7 <= d2; d7 += d5) {
                for (double d8 = d3; d8 <= d4; d8 += d5) {
                    arrayList.clear();
                    PointPlacemark pointPlacemark = new PointPlacemark(Position.fromDegrees(d7, d8, 50000.0));
                    pointPlacemark.setAltitudeMode(n);
                    renderableLayer.addRenderable(pointPlacemark);
                    ++n2;
                }
            }
            System.out.printf("%d Placemarks, Altitude mode = %s\n", n2, arrayList.size(), n == 2 ? "RELATIVE_TO_GROUND" : "ABSOLUTE");
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), renderableLayer);
            this.getLayerPanel().update(this.getWwd());
        }
    }
}

