/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.util.cachecleaner;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.cache.BasicDataFileStore;
import gov.nasa.worldwindx.examples.util.FileStoreDataSet;
import gov.nasa.worldwindx.examples.util.cachecleaner.CacheTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Formatter;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DataCacheViewer {
    protected JPanel panel = new JPanel(new BorderLayout(5, 5));
    protected CacheTable table;
    protected JButton delBtn;
    protected JSpinner ageSpinner;
    protected JComboBox ageUnit;
    protected JLabel deleteSizeLabel;

    public DataCacheViewer(File file) {
        JLabel jLabel = new JLabel("Cache Root: " + file.getPath());
        jLabel.setBorder(new EmptyBorder(10, 15, 10, 10));
        this.panel.add((Component)jLabel, "North");
        this.table = new CacheTable();
        this.table.setDataSets(file.getPath(), FileStoreDataSet.getDataSets(file));
        JScrollPane jScrollPane = new JScrollPane(this.table);
        this.panel.add((Component)jScrollPane, "Center");
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.add((Component)new JLabel("Delete selected data older than"), "West");
        this.ageSpinner = new JSpinner(new SpinnerNumberModel(6, 0, 10000, 1));
        this.ageSpinner.setToolTipText("0 selects the entire dataset regardless of age");
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.ageSpinner);
        jPanel.add((Component)jPanel2, "Center");
        this.ageUnit = new JComboBox<String>(new String[]{"Hours", "Days", "Weeks", "Months", "Years"});
        this.ageUnit.setSelectedItem("Months");
        this.ageUnit.setEditable(false);
        jPanel.add((Component)this.ageUnit, "East");
        JPanel jPanel3 = new JPanel(new BorderLayout(5, 10));
        this.deleteSizeLabel = new JLabel("Total to delete: 0 MB");
        jPanel3.add((Component)this.deleteSizeLabel, "West");
        this.delBtn = new JButton("Delete");
        this.delBtn.setEnabled(false);
        JButton jButton = new JButton("Quit");
        JPanel jPanel4 = new JPanel();
        jPanel4.add(this.delBtn);
        jPanel3.add((Component)jPanel4, "Center");
        jPanel4.add(jButton);
        JPanel jPanel5 = new JPanel(new BorderLayout(5, 10));
        jPanel5.add((Component)jPanel, "West");
        jPanel5.add((Component)jPanel3, "East");
        JPanel jPanel6 = new JPanel(new BorderLayout(10, 10));
        jPanel6.setBorder(new EmptyBorder(10, 10, 20, 10));
        jPanel6.add((Component)jPanel5, "Center");
        this.panel.add((Component)jPanel6, "South");
        this.ageUnit.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                DataCacheViewer.this.update();
            }
        });
        this.ageSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                DataCacheViewer.this.update();
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DataCacheViewer.this.update();
            }
        });
        this.delBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataCacheViewer.this.panel.setCursor(Cursor.getPredefinedCursor(3));
                Thread thread = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            List<FileStoreDataSet> list = DataCacheViewer.this.table.getSelectedDataSets();
                            int n = Integer.parseInt(DataCacheViewer.this.ageSpinner.getValue().toString());
                            String string = DataCacheViewer.this.getUnitKey();
                            for (FileStoreDataSet fileStoreDataSet : list) {
                                fileStoreDataSet.deleteOutOfScopeFiles(string, n, false);
                                if (fileStoreDataSet.getSize() != 0L) continue;
                                DataCacheViewer.this.table.deleteDataSet(fileStoreDataSet);
                                fileStoreDataSet.delete(false);
                            }
                            DataCacheViewer.this.update();
                        }
                        catch (Throwable throwable) {
                            DataCacheViewer.this.update();
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    DataCacheViewer.this.panel.setCursor(Cursor.getDefaultCursor());
                                }
                            });
                            throw throwable;
                        }
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                });
                thread.start();
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
    }

    protected void update() {
        List<FileStoreDataSet> list = this.table.getSelectedDataSets();
        int n = Integer.parseInt(this.ageSpinner.getValue().toString());
        if (list.size() == 0) {
            this.deleteSizeLabel.setText("Total to delete: 0 MB");
            this.delBtn.setEnabled(false);
            return;
        }
        String string = this.getUnitKey();
        long l = 0L;
        for (FileStoreDataSet fileStoreDataSet : list) {
            l += fileStoreDataSet.getOutOfScopeSize(string, n);
        }
        Formatter formatter = new Formatter();
        formatter.format("%5.1f", (double)l / 1000000.0);
        this.deleteSizeLabel.setText("Total to delete: " + formatter.toString() + " MB");
        this.delBtn.setEnabled(true);
    }

    protected String getUnitKey() {
        String string = null;
        String string2 = (String)this.ageUnit.getSelectedItem();
        if (string2.equals("Hours")) {
            string = "gov.nasa.worldwindx.examples.util.cachecleaner.HOUR";
        } else if (string2.equals("Days")) {
            string = "gov.nasa.worldwindx.examples.util.cachecleaner.DAY";
        } else if (string2.equals("Weeks")) {
            string = "gov.nasa.worldwindx.examples.util.cachecleaner.WEEK";
        } else if (string2.equals("Months")) {
            string = "gov.nasa.worldwindx.examples.util.cachecleaner.MONTH";
        } else if (string2.equals("Years")) {
            string = "gov.nasa.worldwindx.examples.util.cachecleaner.YEAR";
        }
        return string;
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame jFrame = new JFrame();
                jFrame.setPreferredSize(new Dimension(800, 300));
                jFrame.setDefaultCloseOperation(3);
                BasicDataFileStore basicDataFileStore = new BasicDataFileStore();
                File file = basicDataFileStore.getWriteLocation();
                DataCacheViewer dataCacheViewer = new DataCacheViewer(file);
                jFrame.getContentPane().add((Component)dataCacheViewer.panel, "Center");
                jFrame.pack();
                Dimension dimension = jFrame.getPreferredSize();
                Point point = new Point(0, 0);
                Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
                int n = point.x + (dimension2.width - dimension.width) / 2;
                int n2 = point.y + (dimension2.height - dimension.height) / 2;
                jFrame.setLocation(n, n2);
                jFrame.setVisible(true);
            }
        });
    }

    static {
        if (Configuration.isMacOS()) {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "World Wind Cache Cleaner");
        }
    }
}

