/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.util;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.render.Highlightable;
import gov.nasa.worldwindx.applications.worldwindow.util.Util;

public class HighlightController
implements SelectListener {
    protected WorldWindow wwd;
    protected Object highlightEventType = "gov.nasa.worldwind.SelectEvent.Rollover";
    protected Highlightable lastHighlightObject;

    public HighlightController(WorldWindow worldWindow, Object object) {
        this.wwd = worldWindow;
        this.highlightEventType = object;
        this.wwd.addSelectListener(this);
    }

    public void dispose() {
        this.wwd.removeSelectListener(this);
    }

    @Override
    public void selected(SelectEvent selectEvent) {
        try {
            if (this.highlightEventType != null && selectEvent.getEventAction().equals(this.highlightEventType)) {
                this.highlight(selectEvent.getTopObject());
            }
        }
        catch (Exception exception) {
            Util.getLogger().warning(exception.getMessage() != null ? exception.getMessage() : exception.toString());
        }
    }

    protected void highlight(Object object) {
        if (this.lastHighlightObject == object) {
            return;
        }
        if (this.lastHighlightObject != null) {
            this.lastHighlightObject.setHighlighted(false);
            this.lastHighlightObject = null;
        }
        if (object instanceof Highlightable) {
            this.lastHighlightObject = (Highlightable)object;
            this.lastHighlightObject.setHighlighted(true);
        }
    }
}

