/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.util;

import gov.nasa.worldwind.View;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.ExtentHolder;
import gov.nasa.worldwind.geom.Frustum;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.view.ViewUtil;
import java.awt.Rectangle;
import java.util.ArrayList;

public class ExtentVisibilitySupport {
    protected static final double EPSILON = 1.0E-6;
    protected static final double SCREEN_POINT_PADDING_PIXELS = 4.0;
    protected Iterable<? extends Extent> extentIterable;
    protected Iterable<? extends ScreenExtent> screenExtentIterable;

    public static Iterable<Extent> extentsFromExtentHolders(Iterable<? extends ExtentHolder> iterable, Globe globe, double d) {
        if (iterable == null) {
            return null;
        }
        ArrayList<Extent> arrayList = new ArrayList<Extent>();
        for (ExtentHolder extentHolder : iterable) {
            Extent extent;
            if (extentHolder == null || (extent = extentHolder.getExtent(globe, d)) == null) continue;
            arrayList.add(extent);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList;
    }

    public Iterable<? extends Extent> getExtents() {
        return this.extentIterable;
    }

    public void setExtents(Iterable<? extends Extent> iterable) {
        this.extentIterable = iterable;
    }

    public Iterable<? extends ScreenExtent> getScreenExtents() {
        return this.screenExtentIterable;
    }

    public void setScreenExtents(Iterable<? extends ScreenExtent> iterable) {
        this.screenExtentIterable = iterable;
    }

    public boolean areExtentsContained(Frustum frustum, Rectangle rectangle) {
        Object object;
        Object object2;
        if (frustum == null) {
            String string = Logging.getMessage("nullValue.FrustumIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (rectangle == null) {
            String string = Logging.getMessage("nullValue.ViewportIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (rectangle.getWidth() <= 0.0) {
            String string = Logging.getMessage("Geom.ViewportWidthInvalid", rectangle.getWidth());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (rectangle.getHeight() <= 0.0) {
            String string = Logging.getMessage("Geom.ViewportHeightInvalid", rectangle.getHeight());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Iterable<? extends Extent> iterable = this.getExtents();
        if (iterable != null) {
            object2 = iterable.iterator();
            while (object2.hasNext()) {
                object = (Extent)object2.next();
                if (object == null || frustum.contains((Extent)object)) continue;
                return false;
            }
        }
        if ((object2 = this.getScreenExtents()) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                ScreenExtent screenExtent = (ScreenExtent)object.next();
                if (screenExtent == null) continue;
                if (screenExtent.getScreenBounds() != null && !rectangle.contains(screenExtent.getScreenBounds())) {
                    return false;
                }
                if (screenExtent.getModelReferencePoint() == null || frustum.contains(screenExtent.getModelReferencePoint())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean areExtentsContained(View view) {
        if (view == null) {
            String string = Logging.getMessage("nullValue.ViewIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.areExtentsContained(view.getFrustumInModelCoordinates(), view.getViewport());
    }

    public Vec4[] computeViewLookAtContainingExtents(Globe globe, double d, Vec4 vec4, Vec4 vec42, Vec4 vec43, Angle angle, Rectangle rectangle, double d2, double d3) {
        Vec4 vec44;
        Iterable<? extends ScreenExtent> iterable;
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.EyeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec42 == null) {
            String string = Logging.getMessage("nullValue.CenterIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec43 == null) {
            String string = Logging.getMessage("nullValue.UpIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle == null) {
            String string = Logging.getMessage("nullValue.FOVIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (rectangle == null) {
            String string = Logging.getMessage("nullValue.ViewportIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = this.validate(vec4, vec42, vec43, angle, rectangle, d2, d3);
        if (string != null) {
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Iterable<? extends Extent> iterable2 = this.getExtents();
        Vec4 vec45 = this.computeCenterPoint(globe, d, iterable2, iterable = this.getScreenExtents());
        if (vec45 == null) {
            vec45 = vec42;
        }
        Position position = globe.computePositionFromPoint(vec42);
        Position position2 = globe.computePositionFromPoint(vec45);
        Matrix matrix = globe.computeSurfaceOrientationAtPosition(position);
        Matrix matrix2 = globe.computeSurfaceOrientationAtPosition(position2);
        Matrix matrix3 = Matrix.fromViewLookAt(vec4, vec42, vec43);
        Matrix matrix4 = Matrix.fromPerspective(angle, rectangle.getWidth(), rectangle.getHeight(), d2, d3);
        Matrix matrix5 = Matrix.IDENTITY;
        matrix5 = matrix5.multiply(matrix2);
        matrix5 = matrix5.multiply(matrix.getInverse());
        matrix5 = matrix5.multiply(matrix3.getInverse());
        Vec4 vec46 = Vec4.UNIT_W.transformBy4(matrix5);
        Vec4 vec47 = Vec4.UNIT_Y.transformBy4(matrix5);
        Matrix matrix6 = Matrix.fromViewLookAt(vec46, vec45, vec47);
        if (iterable != null) {
            iterable = this.translateScreenExtents(iterable, matrix3, matrix6, matrix4, rectangle);
        }
        if ((vec44 = this.computeEyePoint(vec46, vec45, vec47, angle, rectangle, d2, d3, iterable2, iterable)) != null) {
            vec46 = vec44;
        }
        return new Vec4[]{vec46, vec45, vec47};
    }

    public Vec4[] computeViewLookAtContainingExtents(Globe globe, double d, View view) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (view == null) {
            String string = Logging.getMessage("nullValue.ViewIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec4 = view.getEyePoint();
        Vec4 vec42 = view.getCenterPoint();
        Vec4 vec43 = view.getUpVector();
        if (vec42 == null) {
            vec42 = vec4.add3(view.getForwardVector());
        }
        return this.computeViewLookAtContainingExtents(globe, d, vec4, vec42, vec43, view.getFieldOfView(), view.getViewport(), view.getNearClipDistance(), view.getFarClipDistance());
    }

    protected String validate(Vec4 vec4, Vec4 vec42, Vec4 vec43, Angle angle, Rectangle rectangle, double d, double d2) {
        Vec4 vec44 = vec42.subtract3(vec4).normalize3();
        Vec4 vec45 = vec43.normalize3();
        if (vec4.distanceTo3(vec42) <= 1.0E-6) {
            return Logging.getMessage("Geom.EyeAndCenterInvalid", vec4, vec42);
        }
        if (vec44.dot3(vec45) >= 0.999999) {
            return Logging.getMessage("Geom.UpAndLineOfSightInvalid", vec43, vec44);
        }
        if (angle.compareTo(Angle.ZERO) < 0 || angle.compareTo(Angle.POS180) > 0) {
            return Logging.getMessage("Geom.ViewFrustum.FieldOfViewOutOfRange");
        }
        if (rectangle.getWidth() <= 0.0) {
            return Logging.getMessage("Geom.ViewportWidthInvalid", rectangle.getWidth());
        }
        if (rectangle.getHeight() <= 0.0) {
            return Logging.getMessage("Geom.ViewportHeightInvalid", rectangle.getHeight());
        }
        if (d < 0.0 || d2 < 0.0 || d > d2) {
            return Logging.getMessage("Geom.ViewFrustum.ClippingDistanceOutOfRange");
        }
        return null;
    }

    protected Vec4 computeCenterPoint(Globe globe, double d, Iterable<? extends Extent> iterable, Iterable<? extends ScreenExtent> iterable2) {
        ArrayList<Vec4> arrayList = new ArrayList<Vec4>();
        if (iterable != null) {
            for (Extent object : iterable) {
                if (object == null || object.getCenter() == null) continue;
                arrayList.add(object.getCenter());
            }
        }
        if (iterable2 != null) {
            for (ScreenExtent screenExtent : iterable2) {
                if (screenExtent == null || screenExtent.getModelReferencePoint() == null) continue;
                arrayList.add(screenExtent.getModelReferencePoint());
            }
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return Vec4.computeAveragePoint(arrayList);
    }

    protected Vec4 computeEyePoint(Vec4 vec4, Vec4 vec42, Vec4 vec43, Angle angle, Rectangle rectangle, double d, double d2, Iterable<? extends Extent> iterable, Iterable<? extends ScreenExtent> iterable2) {
        Matrix matrix = Matrix.fromViewLookAt(vec4, vec42, vec43);
        Matrix matrix2 = Matrix.fromPerspective(angle, rectangle.getWidth(), rectangle.getHeight(), d, d2);
        Vec4 vec44 = null;
        Vec4 vec45 = this.computeEyePointForModelExtents(vec4, vec42, vec43, angle, rectangle, iterable);
        if (vec45 != null) {
            vec44 = vec45;
            Matrix matrix3 = Matrix.fromViewLookAt(vec44, vec42, vec43);
            if (iterable2 != null) {
                iterable2 = this.translateScreenExtents(iterable2, matrix, matrix3, matrix2, rectangle);
            }
        }
        if ((vec45 = this.computeEyePointForScreenExtents(vec44 != null ? vec44 : vec4, vec42, vec43, angle, rectangle, d, d2, iterable2)) != null && (vec44 == null || vec44.distanceTo3(vec42) < vec45.distanceTo3(vec42))) {
            vec44 = vec45;
        }
        return vec44;
    }

    protected Vec4 computeEyePointForModelExtents(Vec4 vec4, Vec4 vec42, Vec4 vec43, Angle angle, Rectangle rectangle, Iterable<? extends Extent> iterable) {
        if (iterable == null) {
            return null;
        }
        Matrix matrix = Matrix.fromViewLookAt(vec4, vec42, vec43);
        Vec4 vec44 = Vec4.UNIT_NEGATIVE_Z.transformBy4(matrix.getInverse());
        Vec4 vec45 = vec42.transformBy4(matrix);
        Angle angle2 = ViewUtil.computeVerticalFieldOfView(angle, rectangle);
        double d = angle.cosHalfAngle();
        double d2 = angle.tanHalfAngle();
        double d3 = angle2.cosHalfAngle();
        double d4 = angle2.tanHalfAngle();
        double d5 = -1.7976931348623157E308;
        for (Extent extent : iterable) {
            if (extent == null || extent.getCenter() == null) continue;
            Vec4 vec46 = extent.getCenter().transformBy4(matrix);
            double d6 = vec46.z - vec45.z + (Math.abs(vec46.x) + extent.getRadius() / d) / d2;
            if (d5 < d6) {
                d5 = d6;
            }
            if (!(d5 < (d6 = vec46.z - vec45.z + (Math.abs(vec46.y) + extent.getRadius() / d3) / d4))) continue;
            d5 = d6;
        }
        if (d5 == -1.7976931348623157E308) {
            return null;
        }
        return vec42.add3(vec44.multiply3(-d5));
    }

    protected Vec4 computeEyePointForScreenExtents(Vec4 vec4, Vec4 vec42, Vec4 vec43, Angle angle, Rectangle rectangle, double d, double d2, Iterable<? extends ScreenExtent> iterable) {
        if (iterable == null) {
            return null;
        }
        Matrix matrix = Matrix.fromViewLookAt(vec4, vec42, vec43);
        Matrix matrix2 = Matrix.fromPerspective(angle, rectangle.getWidth(), rectangle.getHeight(), d, d2);
        Vec4 vec44 = this.computeEyePointForScreenReferencePoints(vec4, vec42, vec43, angle, rectangle, iterable);
        if (vec44 == null) {
            return null;
        }
        Matrix matrix3 = Matrix.fromViewLookAt(vec44, vec42, vec43);
        Vec4 vec45 = this.computeEyePointForScreenBounds(vec44, vec42, vec43, angle, rectangle, d, d2, iterable = this.translateScreenExtents(iterable, matrix, matrix3, matrix2, rectangle));
        if (vec45 != null) {
            vec44 = vec45;
        }
        return vec44;
    }

    protected Vec4 computeEyePointForScreenReferencePoints(Vec4 vec4, Vec4 vec42, Vec4 vec43, Angle angle, Rectangle rectangle, Iterable<? extends ScreenExtent> iterable) {
        if (iterable == null) {
            return null;
        }
        Matrix matrix = Matrix.fromViewLookAt(vec4, vec42, vec43);
        Vec4 vec44 = Vec4.UNIT_NEGATIVE_Z.transformBy4(matrix.getInverse());
        Vec4 vec45 = vec42.transformBy4(matrix);
        Angle angle2 = ViewUtil.computeVerticalFieldOfView(angle, rectangle);
        double d = angle.tanHalfAngle();
        double d2 = angle2.tanHalfAngle();
        double d3 = -1.7976931348623157E308;
        for (ScreenExtent screenExtent : iterable) {
            if (screenExtent == null || screenExtent.getModelReferencePoint() == null) continue;
            Vec4 vec46 = screenExtent.getModelReferencePoint().transformBy4(matrix);
            double d4 = ViewUtil.computePixelSizeAtDistance(-vec46.z, angle, rectangle);
            double d5 = 4.0 * d4;
            double d6 = vec46.z - vec45.z + (d5 + Math.abs(vec46.x)) / d;
            if (d3 < d6) {
                d3 = d6;
            }
            if (!(d3 < (d6 = vec46.z - vec45.z + (d5 + Math.abs(vec46.y)) / d2))) continue;
            d3 = d6;
        }
        if (d3 == -1.7976931348623157E308) {
            return null;
        }
        return vec42.add3(vec44.multiply3(-d3));
    }

    protected Vec4 computeEyePointForScreenBounds(Vec4 vec4, Vec4 vec42, Vec4 vec43, Angle angle, Rectangle rectangle, double d, double d2, Iterable<? extends ScreenExtent> iterable) {
        if (iterable == null) {
            return null;
        }
        Matrix matrix = Matrix.fromViewLookAt(vec4, vec42, vec43);
        Matrix matrix2 = Matrix.fromPerspective(angle, rectangle.getWidth(), rectangle.getHeight(), d, d2);
        Vec4 vec44 = Vec4.UNIT_NEGATIVE_Z.transformBy4(matrix.getInverse());
        Vec4 vec45 = vec42.transformBy4(matrix);
        double d3 = -1.7976931348623157E308;
        for (ScreenExtent screenExtent : iterable) {
            double d4;
            double d5;
            double d6;
            if (screenExtent == null || screenExtent.getModelReferencePoint() == null || screenExtent.getScreenBounds() == null) continue;
            Vec4 vec46 = screenExtent.getModelReferencePoint().transformBy4(matrix);
            Vec4 vec47 = ViewUtil.project(screenExtent.getModelReferencePoint(), matrix, matrix2, rectangle);
            Rectangle rectangle2 = screenExtent.getScreenBounds();
            if (rectangle2.getWidth() < rectangle.getWidth() && (rectangle2.getMinX() < rectangle.getMinX() || rectangle2.getMaxX() > rectangle.getMaxX())) {
                d6 = Math.abs(rectangle.getCenterX() - vec47.x);
                double d7 = d5 = rectangle2.getMinX() < rectangle.getMinX() ? rectangle.getMinX() - rectangle2.getMinX() : rectangle2.getMaxX() - rectangle.getMaxX();
                if (d5 < d6 && d3 < (d4 = vec46.z - vec45.z + Math.abs(vec46.z) * d6 / (d6 - d5))) {
                    d3 = d4;
                }
            }
            if (!(rectangle2.getHeight() < rectangle.getHeight()) || !(rectangle2.getMinY() < rectangle.getMinY()) && !(rectangle2.getMaxY() > rectangle.getMaxY())) continue;
            d6 = Math.abs(rectangle.getCenterY() - vec47.y);
            double d8 = rectangle2.getMinY() < rectangle.getMinY() ? rectangle.getMinY() - rectangle2.getMinY() : rectangle2.getMaxY() - rectangle.getMaxY();
            d5 = d8;
            if (!(d5 < d6) || !(d3 < (d4 = vec46.z - vec45.z + Math.abs(vec46.z) * d6 / (d6 - d5)))) continue;
            d3 = d4;
        }
        if (d3 == -1.7976931348623157E308) {
            return null;
        }
        return vec42.add3(vec44.multiply3(-d3));
    }

    protected Iterable<ScreenExtent> translateScreenExtents(Iterable<? extends ScreenExtent> iterable, Matrix matrix, Matrix matrix2, Matrix matrix3, Rectangle rectangle) {
        ArrayList<ScreenExtent> arrayList = new ArrayList<ScreenExtent>();
        for (ScreenExtent screenExtent : iterable) {
            if (screenExtent.getModelReferencePoint() != null && screenExtent.getScreenBounds() != null) {
                Vec4 vec4 = ViewUtil.project(screenExtent.getModelReferencePoint(), matrix, matrix3, rectangle);
                Vec4 vec42 = ViewUtil.project(screenExtent.getModelReferencePoint(), matrix2, matrix3, rectangle);
                Vec4 vec43 = vec42.subtract3(vec4);
                Rectangle rectangle2 = new Rectangle(screenExtent.getScreenBounds());
                rectangle2.translate((int)vec43.x, (int)vec43.y);
                arrayList.add(new ScreenExtent(screenExtent.getModelReferencePoint(), rectangle2));
                continue;
            }
            if (screenExtent.getModelReferencePoint() == null) continue;
            arrayList.add(screenExtent);
        }
        return arrayList;
    }

    public static class ScreenExtent {
        protected Vec4 modelReferencePoint;
        protected Rectangle screenBounds;

        public ScreenExtent(Vec4 vec4, Rectangle rectangle) {
            this.modelReferencePoint = vec4;
            this.screenBounds = rectangle != null ? new Rectangle(rectangle) : null;
        }

        public Vec4 getModelReferencePoint() {
            return this.modelReferencePoint;
        }

        public Rectangle getScreenBounds() {
            return this.screenBounds != null ? new Rectangle(this.screenBounds) : null;
        }
    }
}

