/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.util;

import com.jogamp.common.nio.Buffers;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.terrain.Terrain;
import gov.nasa.worldwind.util.Logging;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.List;
import javax.media.opengl.GL2;

public class DirectedPath
extends Path {
    public static final double DEFAULT_ARROW_LENGTH = 300.0;
    public static final Angle DEFAULT_ARROW_ANGLE = Angle.fromDegrees(45.0);
    public static final double DEFAULT_MAX_SCREEN_SIZE = 20.0;
    protected double arrowLength = 300.0;
    protected Angle arrowAngle = DEFAULT_ARROW_ANGLE;
    protected double maxScreenSize = 20.0;
    protected static final String ARROWS_KEY = "DirectedPath.DirectionArrows";

    public DirectedPath() {
    }

    public DirectedPath(Iterable<? extends Position> iterable) {
        super(iterable);
    }

    public DirectedPath(Position.PositionList positionList) {
        super(positionList.list);
    }

    public DirectedPath(Position position, Position position2) {
        super(position, position2);
    }

    public double getArrowLength() {
        return this.arrowLength;
    }

    public void setArrowLength(double d) {
        if (d <= 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.arrowLength = d;
    }

    public double getMaxScreenSize() {
        return this.maxScreenSize;
    }

    public void setMaxScreenSize(double d) {
        if (d <= 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.maxScreenSize = d;
    }

    public Angle getArrowAngle() {
        return this.arrowAngle;
    }

    public void setArrowAngle(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull", angle);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle.compareTo(Angle.ZERO) <= 0 || angle.compareTo(Angle.POS90) >= 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", angle);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.arrowAngle = angle;
    }

    @Override
    protected void computePath(DrawContext drawContext, List<Position> list, Path.PathData pathData) {
        super.computePath(drawContext, list, pathData);
    }

    protected void computeDirectionArrows(DrawContext drawContext, Path.PathData pathData) {
        IntBuffer intBuffer = pathData.getPolePositions();
        int n = intBuffer.limit() / 2;
        List<Position> list = pathData.getTessellatedPositions();
        FloatBuffer floatBuffer = (FloatBuffer)pathData.getValue(ARROWS_KEY);
        if (floatBuffer == null || floatBuffer.capacity() < n * 9) {
            floatBuffer = Buffers.newDirectFloatBuffer((int)(9 * n));
        }
        pathData.setValue(ARROWS_KEY, floatBuffer);
        floatBuffer.clear();
        Terrain terrain = drawContext.getTerrain();
        double d = this.getArrowLength() * this.getArrowAngle().tanHalfAngle();
        int n2 = intBuffer.get(0) / 2;
        Position position = list.get(n2);
        Vec4 vec4 = this.computePoint(terrain, position);
        for (int i = 2; i < intBuffer.limit(); i += 2) {
            int n3 = intBuffer.get(i) / 2;
            Position position2 = list.get(n3);
            Vec4 vec42 = this.computePoint(terrain, position2);
            int n4 = (n2 + n3) / 2;
            Position position3 = list.get(n4);
            Position position4 = list.get(n4 + 1);
            Vec4 vec43 = this.computePoint(terrain, position3);
            Vec4 vec44 = this.computePoint(terrain, position4);
            this.computeArrowheadGeometry(drawContext, vec4, vec42, vec43, vec44, this.getArrowLength(), d, floatBuffer, pathData);
            n2 = n3;
            vec4 = vec42;
        }
    }

    protected void computeArrowheadGeometry(DrawContext drawContext, Vec4 vec4, Vec4 vec42, Vec4 vec43, Vec4 vec44, double d, double d2, FloatBuffer floatBuffer, Path.PathData pathData) {
        double d3 = vec4.distanceTo3(vec42);
        Vec4 vec45 = vec43.subtract3(vec44);
        Vec4 vec46 = drawContext.getGlobe().computeSurfaceNormalAtPoint(vec44);
        Vec4 vec47 = vec46.cross3(vec45);
        Vec4 vec48 = vec43.add3(vec44).divide3(2.0);
        if (!this.isArrowheadSmall(drawContext, vec48, 1)) {
            double d4;
            View view = drawContext.getView();
            double d5 = view.computePixelSizeAtDistance(d4 = view.getEyePoint().distanceTo3(vec48));
            if (d / d5 > this.maxScreenSize) {
                d = this.maxScreenSize * d5;
                d2 = d * this.getArrowAngle().tanHalfAngle();
            }
            if (d3 <= d) {
                return;
            }
            vec47 = vec47.normalize3().multiply3(d2);
            vec45 = vec45.normalize3().multiply3(d);
            if (d3 > d) {
                vec48 = vec48.subtract3(vec45.divide3(2.0));
            }
            Vec4 vec49 = vec48.add3(vec45).add3(vec47);
            Vec4 vec410 = vec48.add3(vec45).add3(vec47.multiply3(-1.0));
            Vec4 vec411 = pathData.getReferencePoint();
            floatBuffer.put((float)(vec49.x - vec411.x));
            floatBuffer.put((float)(vec49.y - vec411.y));
            floatBuffer.put((float)(vec49.z - vec411.z));
            floatBuffer.put((float)(vec410.x - vec411.x));
            floatBuffer.put((float)(vec410.y - vec411.y));
            floatBuffer.put((float)(vec410.z - vec411.z));
            floatBuffer.put((float)(vec48.x - vec411.x));
            floatBuffer.put((float)(vec48.y - vec411.y));
            floatBuffer.put((float)(vec48.z - vec411.z));
        }
    }

    protected boolean isArrowheadSmall(DrawContext drawContext, Vec4 vec4, int n) {
        return this.getArrowLength() <= (double)n * drawContext.getView().computePixelSizeAtDistance(drawContext.getView().getEyePoint().distanceTo3(vec4));
    }

    @Override
    protected void doDrawOutline(DrawContext drawContext) {
        this.computeDirectionArrows(drawContext, this.getCurrentPathData());
        this.drawDirectionArrows(drawContext, this.getCurrentPathData());
        super.doDrawOutline(drawContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawDirectionArrows(DrawContext drawContext, Path.PathData pathData) {
        GL2 gL2 = drawContext.getGL().getGL2();
        boolean bl = false;
        try {
            if (this.isSurfacePath()) {
                drawContext.pushProjectionOffest(0.99);
                gL2.glDepthMask(false);
                bl = true;
            }
            FloatBuffer floatBuffer = (FloatBuffer)pathData.getValue(ARROWS_KEY);
            gL2.glVertexPointer(3, 5126, 0, floatBuffer.rewind());
            gL2.glDrawArrays(4, 0, floatBuffer.limit() / 3);
        }
        finally {
            if (bl) {
                drawContext.popProjectionOffest();
                gL2.glDepthMask(true);
            }
        }
    }
}

