/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.util;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.render.Annotation;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwindx.examples.util.ButtonAnnotation;
import gov.nasa.worldwindx.examples.util.DialogAnnotation;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;

public abstract class DialogAnnotationController
implements ActionListener,
SelectListener {
    private WorldWindow wwd;
    private boolean enabled;
    private DialogAnnotation annotation;
    protected ButtonAnnotation toolTipComponent;

    public DialogAnnotationController(WorldWindow worldWindow, DialogAnnotation dialogAnnotation) {
        if (worldWindow == null) {
            String string = Logging.getMessage("nullValue.WorldWindow");
            Logging.logger().log(Level.SEVERE, string);
            throw new IllegalArgumentException(string);
        }
        this.wwd = worldWindow;
        this.setAnnotation(dialogAnnotation);
    }

    public WorldWindow getWorldWindow() {
        return this.wwd;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        if (!this.enabled && bl) {
            this.doEnable();
        } else if (this.enabled && !bl) {
            this.doDisable();
        }
        this.enabled = bl;
    }

    protected void doEnable() {
        this.getWorldWindow().addSelectListener(this);
    }

    protected void doDisable() {
        this.getWorldWindow().removeSelectListener(this);
    }

    public DialogAnnotation getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(DialogAnnotation dialogAnnotation) {
        if (this.annotation == dialogAnnotation) {
            return;
        }
        if (this.annotation != null) {
            this.annotation.removeActionListener(this);
        }
        this.annotation = dialogAnnotation;
        if (this.annotation != null) {
            this.annotation.addActionListener(this);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent == null) {
            return;
        }
        this.onActionPerformed(actionEvent);
    }

    protected void onActionPerformed(ActionEvent actionEvent) {
    }

    @Override
    public void selected(SelectEvent selectEvent) {
        if (selectEvent == null) {
            return;
        }
        this.onSelected(selectEvent);
    }

    protected void onSelected(SelectEvent selectEvent) {
        this.forwardToButtonAnnotations(this.getAnnotation(), selectEvent);
        this.updateCursor(selectEvent);
        this.updateToolTip(selectEvent);
    }

    protected void forwardToButtonAnnotations(Annotation annotation, SelectEvent selectEvent) {
        if (annotation instanceof ButtonAnnotation) {
            ((ButtonAnnotation)annotation).selected(selectEvent);
        }
        for (Annotation annotation2 : annotation.getChildren()) {
            this.forwardToButtonAnnotations(annotation2, selectEvent);
        }
    }

    protected void updateCursor(SelectEvent selectEvent) {
        Object object = selectEvent.getTopObject();
        if (object != null && object instanceof ButtonAnnotation) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else if (object != null && object instanceof DialogAnnotation) {
            if (((DialogAnnotation)object).isBusy()) {
                this.setCursor(Cursor.getPredefinedCursor(3));
            } else {
                this.setCursor(Cursor.getDefaultCursor());
            }
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    protected void setCursor(Cursor cursor) {
        Component component;
        if (this.getWorldWindow() instanceof Component && !(component = (Component)((Object)this.getWorldWindow())).getCursor().equals(cursor)) {
            component.setCursor(cursor);
        }
    }

    protected void updateToolTip(SelectEvent selectEvent) {
        if (selectEvent.getEventAction() != "gov.nasa.worldwind.SelectEvent.Hover") {
            return;
        }
        Object object = selectEvent.getTopObject();
        if (object != null && object instanceof ButtonAnnotation) {
            this.showToolTip(selectEvent, (ButtonAnnotation)object);
        } else {
            this.showToolTip(selectEvent, null);
        }
    }

    protected void showToolTip(SelectEvent selectEvent, ButtonAnnotation buttonAnnotation) {
        if (this.toolTipComponent == buttonAnnotation) {
            return;
        }
        if (this.toolTipComponent != null) {
            this.toolTipComponent.setShowToolTip(false);
            this.toolTipComponent.setToolTipPoint(null);
            this.toolTipComponent = null;
        }
        if (buttonAnnotation != null) {
            Point point = this.getToolTipPoint(selectEvent);
            this.toolTipComponent = buttonAnnotation;
            this.toolTipComponent.setShowToolTip(true);
            this.toolTipComponent.setToolTipPoint(point);
        }
        this.getWorldWindow().redraw();
    }

    protected Point getToolTipPoint(SelectEvent selectEvent) {
        Point point = selectEvent.getPickPoint();
        if (selectEvent.getSource() instanceof Component) {
            point = this.glPointFromAwt((Component)selectEvent.getSource(), point);
        }
        return new Point(point.x, point.y - 40);
    }

    protected Point glPointFromAwt(Component component, Point point) {
        return new Point(point.x, component.getHeight() - point.y - 1);
    }
}

