/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.multiwindow;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.awt.WorldWindowGLCanvas;
import gov.nasa.worldwind.util.StatusBar;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwindx.examples.multiwindow.ViewVolumeViewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ViewViewVolume
extends JFrame {
    protected WWPanel wwp;

    public ViewViewVolume() {
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.wwp = new WWPanel(new Dimension(650, 500));
        this.getContentPane().add(this.wwp);
        this.pack();
        this.setResizable(true);
        WWUtil.alignComponent(null, this, "gov.nasa.worldwind.avkey.Center");
        this.setDefaultCloseOperation(3);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ViewViewVolume viewViewVolume = new ViewViewVolume();
                viewViewVolume.setVisible(true);
                ViewVolumeViewer viewVolumeViewer = new ViewVolumeViewer(viewViewVolume.wwp.wwd, new Dimension(500, 500));
                Point point = viewViewVolume.getLocation();
                viewVolumeViewer.setLocation(point.x + viewViewVolume.getWidth() + 20, point.y);
                viewVolumeViewer.setVisible(true);
            }
        });
    }

    static {
        if (Configuration.isMacOS()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "World Wind Multi-Window Analysis");
            System.setProperty("com.apple.mrj.application.growbox.intrudes", "false");
        }
    }

    protected static class WWPanel
    extends JPanel {
        WorldWindowGLCanvas wwd = new WorldWindowGLCanvas();

        public WWPanel(Dimension dimension) {
            this.wwd.setSize(dimension);
            this.wwd.setModel((Model)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.ModelClassName"));
            this.setLayout(new BorderLayout(5, 5));
            this.add((Component)((Object)this.wwd), "Center");
            StatusBar statusBar = new StatusBar();
            statusBar.setEventSource(this.wwd);
            this.add((Component)statusBar, "South");
        }
    }
}

