/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.kml;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.animation.AngleAnimator;
import gov.nasa.worldwind.animation.AnimationSupport;
import gov.nasa.worldwind.animation.Interpolator;
import gov.nasa.worldwind.animation.PositionAnimator;
import gov.nasa.worldwind.animation.ScheduledInterpolator;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.ogc.kml.KMLCamera;
import gov.nasa.worldwind.ogc.kml.KMLLookAt;
import gov.nasa.worldwind.ogc.kml.impl.KMLUtil;
import gov.nasa.worldwind.util.PropertyAccessor;
import gov.nasa.worldwind.view.ViewElevationAnimator;
import gov.nasa.worldwind.view.ViewPropertyAccessor;
import gov.nasa.worldwind.view.firstperson.BasicFlyView;
import gov.nasa.worldwind.view.orbit.FlyToOrbitViewAnimator;
import gov.nasa.worldwind.view.orbit.OrbitView;
import gov.nasa.worldwind.view.orbit.OrbitViewInputHandler;
import gov.nasa.worldwind.view.orbit.OrbitViewPropertyAccessor;
import gov.nasa.worldwindx.examples.kml.KMLViewController;

public class KMLOrbitViewController
extends KMLViewController {
    protected final long MIN_LENGTH_MILLIS = 4000L;
    protected final long MAX_LENGTH_MILLIS = 16000L;
    protected OrbitView orbitView;

    protected KMLOrbitViewController(WorldWindow worldWindow) {
        super(worldWindow);
        this.orbitView = (OrbitView)worldWindow.getView();
    }

    @Override
    protected void goTo(KMLLookAt kMLLookAt) {
        double d = kMLLookAt.getLatitude() != null ? kMLLookAt.getLatitude() : 0.0;
        double d2 = kMLLookAt.getLongitude() != null ? kMLLookAt.getLongitude() : 0.0;
        double d3 = kMLLookAt.getAltitude() != null ? kMLLookAt.getAltitude() : 0.0;
        double d4 = kMLLookAt.getHeading() != null ? kMLLookAt.getHeading() : 0.0;
        double d5 = kMLLookAt.getTilt() != null ? kMLLookAt.getTilt() : 0.0;
        double d6 = kMLLookAt.getRange() != null ? kMLLookAt.getRange() : 0.0;
        String string = kMLLookAt.getAltitudeMode();
        Position position = Position.fromDegrees(d, d2, d3);
        long l = AnimationSupport.getScaledTimeMillisecs(this.orbitView.getCenterPosition(), position, 4000L, 16000L);
        FlyToOrbitViewAnimator flyToOrbitViewAnimator = FlyToOrbitViewAnimator.createFlyToOrbitViewAnimator(this.orbitView, this.orbitView.getCenterPosition(), position, this.orbitView.getHeading(), Angle.fromDegrees(d4), this.orbitView.getPitch(), Angle.fromDegrees(d5), this.orbitView.getZoom(), d6, l, KMLUtil.convertAltitudeMode(string, 1));
        OrbitViewInputHandler orbitViewInputHandler = (OrbitViewInputHandler)this.orbitView.getViewInputHandler();
        orbitViewInputHandler.stopAnimators();
        orbitViewInputHandler.addAnimator(flyToOrbitViewAnimator);
    }

    @Override
    protected void goTo(KMLCamera kMLCamera) {
        double d = kMLCamera.getLatitude() != null ? kMLCamera.getLatitude() : 0.0;
        double d2 = kMLCamera.getLongitude() != null ? kMLCamera.getLongitude() : 0.0;
        double d3 = kMLCamera.getAltitude() != null ? kMLCamera.getAltitude() : 0.0;
        double d4 = kMLCamera.getHeading() != null ? kMLCamera.getHeading() : 0.0;
        double d5 = kMLCamera.getTilt() != null ? kMLCamera.getTilt() : 0.0;
        double d6 = kMLCamera.getRoll() != null ? kMLCamera.getRoll() : 0.0;
        d6 = -d6;
        String string = kMLCamera.getAltitudeMode();
        Position position = Position.fromDegrees(d, d2, d3);
        long l = AnimationSupport.getScaledTimeMillisecs(this.orbitView.getEyePosition(), position, 4000L, 16000L);
        FlyToOrbitViewAnimator flyToOrbitViewAnimator = this.createFlyToOrbitViewAnimator(this.orbitView, position, Angle.fromDegrees(d4), Angle.fromDegrees(d5), Angle.fromDegrees(d6), l, KMLUtil.convertAltitudeMode(string, 2));
        OrbitViewInputHandler orbitViewInputHandler = (OrbitViewInputHandler)this.orbitView.getViewInputHandler();
        orbitViewInputHandler.stopAnimators();
        orbitViewInputHandler.addAnimator(flyToOrbitViewAnimator);
    }

    protected FlyToOrbitViewAnimator createFlyToOrbitViewAnimator(OrbitView orbitView, Position position, Angle angle, Angle angle2, Angle angle3, long l, int n) {
        Globe globe = orbitView.getGlobe();
        BasicFlyView basicFlyView = new BasicFlyView();
        basicFlyView.setGlobe(globe);
        basicFlyView.setEyePosition(position);
        basicFlyView.setHeading(angle);
        basicFlyView.setPitch(angle2);
        Vec4 vec4 = globe.computePointFromPosition(position);
        Vec4 vec42 = basicFlyView.getCurrentForwardVector();
        Position position2 = this.computeCenterPosition(position, vec42, angle2, n);
        double d = vec4.distanceTo3(globe.computePointFromPosition(position2));
        EyePositionAnimator eyePositionAnimator = new EyePositionAnimator(new ScheduledInterpolator(l), orbitView.getCenterPosition(), position2, position, vec42, angle2, OrbitViewPropertyAccessor.createCenterPositionAccessor(orbitView), n);
        ViewElevationAnimator viewElevationAnimator = new ViewElevationAnimator(globe, orbitView.getZoom(), d, orbitView.getCenterPosition(), position, 0, OrbitViewPropertyAccessor.createZoomAccessor(orbitView));
        eyePositionAnimator.useMidZoom = viewElevationAnimator.getUseMidZoom();
        AngleAnimator angleAnimator = new AngleAnimator(new ScheduledInterpolator(l), orbitView.getHeading(), angle, ViewPropertyAccessor.createHeadingAccessor(orbitView));
        AngleAnimator angleAnimator2 = new AngleAnimator(new ScheduledInterpolator(l), orbitView.getPitch(), angle2, ViewPropertyAccessor.createPitchAccessor(orbitView));
        AngleAnimator angleAnimator3 = new AngleAnimator(new ScheduledInterpolator(l), orbitView.getRoll(), angle3, ViewPropertyAccessor.createRollAccessor(orbitView));
        return new FlyToOrbitViewAnimator(orbitView, new ScheduledInterpolator(l), n, eyePositionAnimator, viewElevationAnimator, angleAnimator, angleAnimator2, angleAnimator3);
    }

    protected Position computeCenterPosition(Position position, Vec4 vec4, Angle angle, int n) {
        Angle angle2 = position.getLatitude();
        Angle angle3 = position.getLongitude();
        Globe globe = this.wwd.getModel().getGlobe();
        double d = n == 1 ? globe.getElevation(angle2, angle3) : (n == 2 ? globe.getElevation(angle2, angle3) + position.getAltitude() : position.getAltitude());
        Vec4 vec42 = globe.computePointFromPosition(new Position(angle2, angle3, d));
        Position position2 = Math.abs(angle.degrees - 90.0) > 0.001 ? globe.getIntersectionPosition(new Line(vec42, vec4)) : globe.computePositionFromPoint(vec42);
        return position2;
    }

    protected class EyePositionAnimator
    extends PositionAnimator {
        protected Position endEyePosition;
        protected int eyeAltitudeMode;
        protected boolean useMidZoom;
        protected Vec4 forward;
        protected Angle pitch;

        public EyePositionAnimator(Interpolator interpolator, Position position, Position position2, Position position3, Vec4 vec4, Angle angle, PropertyAccessor.PositionAccessor positionAccessor, int n) {
            super(interpolator, position, position2, positionAccessor);
            this.useMidZoom = true;
            this.forward = vec4;
            this.pitch = angle;
            this.endEyePosition = position3;
            this.eyeAltitudeMode = n;
        }

        @Override
        protected Position nextPosition(double d) {
            double d2 = this.useMidZoom ? 0.2 : 0.0;
            double d3 = this.useMidZoom ? 0.8 : 0.8;
            double d4 = AnimationSupport.basicInterpolant(d, d2, d3, 1);
            Position position = super.nextPosition(d4);
            if (this.eyeAltitudeMode == 1 || this.eyeAltitudeMode == 2) {
                Position position2 = KMLOrbitViewController.this.computeCenterPosition(this.endEyePosition, this.forward, this.pitch, this.eyeAltitudeMode);
                Position position3 = position;
                double d5 = this.getBegin().getElevation();
                position = new Position(position3, (1.0 - d4) * d5 + d4 * position2.getElevation());
            }
            return position;
        }
    }
}

