/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.analytics;

import com.jogamp.opengl.util.awt.TextRenderer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ScreenImage;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLTextRenderer;
import gov.nasa.worldwind.util.WWMath;
import gov.nasa.worldwind.util.WWUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.Format;
import java.util.ArrayList;

public class AnalyticSurfaceLegend
implements Renderable {
    protected static final Font DEFAULT_FONT = Font.decode("Arial-PLAIN-12");
    protected static final Color DEFAULT_COLOR = Color.WHITE;
    protected static final int DEFAULT_WIDTH = 32;
    protected static final int DEFAULT_HEIGHT = 256;
    protected boolean visible = true;
    protected ScreenImage screenImage;
    protected Iterable<? extends Renderable> labels;

    public static AnalyticSurfaceLegend fromColorGradient(int n, int n2, double d, double d2, double d3, double d4, Color color, Iterable<? extends LabelAttributes> iterable, LabelAttributes labelAttributes) {
        AnalyticSurfaceLegend analyticSurfaceLegend = new AnalyticSurfaceLegend();
        analyticSurfaceLegend.screenImage = new ScreenImage();
        analyticSurfaceLegend.screenImage.setImageSource(analyticSurfaceLegend.createColorGradientLegendImage(n, n2, d3, d4, color));
        analyticSurfaceLegend.labels = analyticSurfaceLegend.createColorGradientLegendLabels(n, n2, d, d2, iterable, labelAttributes);
        return analyticSurfaceLegend;
    }

    public static AnalyticSurfaceLegend fromColorGradient(double d, double d2, double d3, double d4, Iterable<? extends LabelAttributes> iterable, LabelAttributes labelAttributes) {
        return AnalyticSurfaceLegend.fromColorGradient(32, 256, d, d2, d3, d4, DEFAULT_COLOR, iterable, labelAttributes);
    }

    protected AnalyticSurfaceLegend() {
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public double getOpacity() {
        return this.screenImage.getOpacity();
    }

    public void setOpacity(double d) {
        if (d < 0.0 || d > 1.0) {
            String string = Logging.getMessage("generic.OpacityOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.screenImage.setOpacity(d);
    }

    public Point getScreenLocation(DrawContext drawContext) {
        return this.screenImage.getScreenLocation(drawContext);
    }

    public void setScreenLocation(Point point) {
        if (point == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.screenImage.setScreenLocation(point);
    }

    public int getWidth(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.screenImage.getImageWidth(drawContext);
    }

    public int getHeight(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.screenImage.getImageHeight(drawContext);
    }

    @Override
    public void render(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.isVisible()) {
            return;
        }
        this.doRender(drawContext);
    }

    public static Iterable<? extends LabelAttributes> createDefaultColorGradientLabels(double d, double d2, Format format) {
        if (format == null) {
            String string = Logging.getMessage("nullValue.Format");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ArrayList<LabelAttributes> arrayList = new ArrayList<LabelAttributes>();
        int n = 5;
        Font font = Font.decode("Arial-BOLD-12");
        for (int i = 0; i < n; ++i) {
            double d3 = WWMath.mix((double)i / (double)(n - 1), d, d2);
            String string = format.format(d3);
            if (WWUtil.isEmpty(string)) continue;
            arrayList.add(AnalyticSurfaceLegend.createLegendLabelAttributes(d3, string, font, Color.WHITE, 5.0, 0.0));
        }
        return arrayList;
    }

    public static LabelAttributes createDefaultTitle(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        Font font = Font.decode("Arial-BOLD-16");
        return AnalyticSurfaceLegend.createLegendLabelAttributes(0.0, string, font, Color.WHITE, 0.0, -20.0);
    }

    public static LabelAttributes createLegendLabelAttributes(final double d, final String string, final Font font, final Color color, final double d2, final double d3) {
        return new LabelAttributes(){

            @Override
            public double getValue() {
                return d;
            }

            @Override
            public String getText() {
                return string;
            }

            @Override
            public Font getFont() {
                return font;
            }

            @Override
            public Color getColor() {
                return color;
            }

            @Override
            public Point2D getOffset() {
                return new Point2D.Double(d2, d3);
            }
        };
    }

    protected void doRender(DrawContext drawContext) {
        this.screenImage.render(drawContext);
        if (!drawContext.isPickingMode() && this.labels != null) {
            for (Renderable renderable : this.labels) {
                if (renderable == null) continue;
                renderable.render(drawContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawLabel(DrawContext drawContext, LabelAttributes labelAttributes, double d, double d2, String string, String string2) {
        TextRenderer textRenderer;
        Point2D point2D;
        Point point;
        String string3 = labelAttributes.getText();
        if (WWUtil.isEmpty(string3)) {
            return;
        }
        Font font = labelAttributes.getFont();
        if (font == null) {
            font = DEFAULT_FONT;
        }
        Color color = DEFAULT_COLOR;
        if (labelAttributes.getColor() != null) {
            color = labelAttributes.getColor();
        }
        if ((point = this.getScreenLocation(drawContext)) != null) {
            d += point.getX() - (double)(this.screenImage.getImageWidth(drawContext) / 2);
            d2 += point.getY() - (double)(this.screenImage.getImageHeight(drawContext) / 2);
        }
        if ((point2D = labelAttributes.getOffset()) != null) {
            d += point2D.getX();
            d2 += point2D.getY();
        }
        if ((textRenderer = OGLTextRenderer.getOrCreateTextRenderer(drawContext.getTextRendererCache(), font)) == null) {
            return;
        }
        Rectangle2D rectangle2D = textRenderer.getBounds(string3);
        if (rectangle2D != null) {
            if ("gov.nasa.worldwind.avkey.Center".equals(string)) {
                d += -(rectangle2D.getWidth() / 2.0);
            }
            if ("gov.nasa.worldwind.avkey.Right".equals(string)) {
                d += -rectangle2D.getWidth();
            }
            if ("gov.nasa.worldwind.avkey.Center".equals(string2)) {
                d2 += rectangle2D.getHeight() + rectangle2D.getY();
            }
            if ("gov.nasa.worldwind.avkey.Top".equals(string2)) {
                d2 += rectangle2D.getHeight();
            }
        }
        Rectangle rectangle = drawContext.getView().getViewport();
        textRenderer.beginRendering(rectangle.width, rectangle.height);
        try {
            double d3 = (double)rectangle.height - d2 - 1.0;
            textRenderer.setColor(WWUtil.computeContrastingColor(color));
            textRenderer.draw(string3, (int)d - 1, (int)d3 - 1);
            textRenderer.draw(string3, (int)d + 1, (int)d3 - 1);
            textRenderer.draw(string3, (int)d + 1, (int)d3 + 1);
            textRenderer.draw(string3, (int)d - 1, (int)d3 + 1);
            textRenderer.setColor(color);
            textRenderer.draw(string3, (int)d, (int)d3);
        }
        finally {
            textRenderer.endRendering();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedImage createColorGradientLegendImage(int n, int n2, double d, double d2, Color color) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 6);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            for (int i = 0; i < n2; ++i) {
                double d3 = WWMath.mix(1.0 - (double)i / (double)(n2 - 1), d, d2);
                graphics2D.setColor(Color.getHSBColor((float)d3, 1.0f, 1.0f));
                graphics2D.drawLine(0, i, n - 1, i);
            }
            if (color != null) {
                graphics2D.setColor(color);
                graphics2D.drawRect(0, 0, n - 1, n2 - 1);
            }
        }
        finally {
            graphics2D.dispose();
        }
        return bufferedImage;
    }

    protected Iterable<? extends Renderable> createColorGradientLegendLabels(int n, int n2, double d, double d2, Iterable<? extends LabelAttributes> iterable, LabelAttributes labelAttributes) {
        ArrayList<LabelRenderable> arrayList = new ArrayList<LabelRenderable>();
        if (iterable != null) {
            for (LabelAttributes labelAttributes2 : iterable) {
                if (labelAttributes2 == null) continue;
                double d3 = WWMath.computeInterpolationFactor(labelAttributes2.getValue(), d, d2);
                double d4 = (1.0 - d3) * (double)(n2 - 1);
                arrayList.add(new LabelRenderable(this, labelAttributes2, n, d4, "gov.nasa.worldwind.avkey.Left", "gov.nasa.worldwind.avkey.Center"));
            }
        }
        if (labelAttributes != null) {
            arrayList.add(new LabelRenderable(this, labelAttributes, (double)n / 2.0, 0.0, "gov.nasa.worldwind.avkey.Center", "gov.nasa.worldwind.avkey.Bottom"));
        }
        return arrayList;
    }

    protected static class OrderedLabel
    implements OrderedRenderable {
        protected final AnalyticSurfaceLegend legend;
        protected final LabelAttributes attr;
        protected final double x;
        protected final double y;
        protected final String halign;
        protected final String valign;

        public OrderedLabel(AnalyticSurfaceLegend analyticSurfaceLegend, LabelAttributes labelAttributes, double d, double d2, String string, String string2) {
            this.legend = analyticSurfaceLegend;
            this.attr = labelAttributes;
            this.x = d;
            this.y = d2;
            this.halign = string;
            this.valign = string2;
        }

        @Override
        public double getDistanceFromEye() {
            return 0.0;
        }

        @Override
        public void render(DrawContext drawContext) {
            this.legend.drawLabel(drawContext, this.attr, this.x, this.y, this.halign, this.valign);
        }

        @Override
        public void pick(DrawContext drawContext, Point point) {
        }
    }

    protected static class LabelRenderable
    implements Renderable {
        protected final OrderedLabel orderedLabel;

        public LabelRenderable(AnalyticSurfaceLegend analyticSurfaceLegend, LabelAttributes labelAttributes, double d, double d2, String string, String string2) {
            this.orderedLabel = new OrderedLabel(analyticSurfaceLegend, labelAttributes, d, d2, string, string2);
        }

        @Override
        public void render(DrawContext drawContext) {
            drawContext.addOrderedRenderable(this.orderedLabel);
        }
    }

    public static interface LabelAttributes {
        public double getValue();

        public String getText();

        public Font getFont();

        public Color getColor();

        public Point2D getOffset();
    }
}

