/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.BasicModel;
import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.awt.WorldWindowGLCanvas;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Shutdown {
    public static void main(String[] stringArray) {
        if (Configuration.isMacOS()) {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "Shutdown World Wind");
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AppFrame appFrame = new AppFrame();
                appFrame.setDefaultCloseOperation(3);
                appFrame.setVisible(true);
            }
        });
    }

    private static class AppFrame
    extends JFrame {
        private WorldWindow wwd;
        private ShutdownWindowAction shutdownAction;
        private CreateWindowAction createWindowAction;

        public AppFrame() {
            this.getContentPane().setLayout(new BorderLayout(10, 10));
            JPanel jPanel = new JPanel(new BorderLayout(10, 10));
            this.getContentPane().add((Component)jPanel, "West");
            JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 10, 10));
            jPanel.add((Component)jPanel2, "North");
            this.shutdownAction = new ShutdownWindowAction();
            jPanel2.add(new JButton(this.shutdownAction));
            this.shutdownAction.setEnabled(true);
            this.createWindowAction = new CreateWindowAction();
            jPanel2.add(new JButton(this.createWindowAction));
            jPanel2.add(new JButton(new ShutdownWorldWindAction()));
            this.createWindow();
            this.pack();
        }

        private void createWindow() {
            WorldWindowGLCanvas worldWindowGLCanvas = new WorldWindowGLCanvas();
            worldWindowGLCanvas.setPreferredSize(new Dimension(800, 600));
            this.getContentPane().add((Component)((Object)worldWindowGLCanvas), "Center");
            worldWindowGLCanvas.setModel(new BasicModel());
            this.wwd = worldWindowGLCanvas;
        }

        private void destroyCurrentWindow() {
            if (this.wwd != null) {
                this.getContentPane().remove((Component)((Object)this.wwd));
                this.wwd = null;
            }
        }

        private class ShutdownWorldWindAction
        extends AbstractAction {
            public ShutdownWorldWindAction() {
                super("Shutdown World Wind");
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WorldWind.shutDown();
                AppFrame.this.destroyCurrentWindow();
                AppFrame.this.createWindowAction.setEnabled(true);
            }
        }

        private class CreateWindowAction
        extends AbstractAction {
            public CreateWindowAction() {
                super("Create Window");
                this.setEnabled(false);
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AppFrame.this.createWindow();
                AppFrame.this.pack();
                this.setEnabled(false);
                AppFrame.this.shutdownAction.setEnabled(true);
            }
        }

        private class ShutdownWindowAction
        extends AbstractAction {
            public ShutdownWindowAction() {
                super("Shutdown Window");
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (AppFrame.this.wwd != null) {
                    AppFrame.this.wwd.shutdown();
                    AppFrame.this.destroyCurrentWindow();
                    this.setEnabled(false);
                    AppFrame.this.createWindowAction.setEnabled(true);
                }
            }
        }
    }
}

