/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.layers.placename.PlaceNameLayer;
import gov.nasa.worldwind.layers.placename.PlaceNameService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class PlaceNamesPanel
extends JPanel
implements ItemListener {
    List<PlaceNameService> nameServices;
    PlaceNameLayer nameLayer;
    WorldWindow wwd;
    ArrayList<JCheckBox> cbList = new ArrayList();

    public PlaceNamesPanel(WorldWindow worldWindow) {
        super(new BorderLayout());
        this.wwd = worldWindow;
        LayerList layerList = this.wwd.getModel().getLayers();
        for (Layer layer : layerList) {
            if (!(layer instanceof PlaceNameLayer)) continue;
            this.nameLayer = (PlaceNameLayer)layer;
            break;
        }
        if (this.nameLayer != null) {
            this.nameServices = this.nameLayer.getPlaceNameServiceSet().getServices();
            this.makePanel();
        }
    }

    private void makePanel() {
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jPanel2 = new JPanel(new GridLayout(0, 2, 0, 0));
        for (PlaceNameService placeNameService : this.nameServices) {
            JCheckBox jCheckBox = new JCheckBox(placeNameService.getDataset(), true);
            jCheckBox.addItemListener(this);
            jPanel2.add(jCheckBox);
            this.cbList.add(jCheckBox);
        }
        jPanel.add(jPanel2);
        this.add((Component)jPanel, "Center");
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        for (PlaceNameService placeNameService : this.nameServices) {
            if (!placeNameService.getDataset().equalsIgnoreCase(((JCheckBox)itemEvent.getSource()).getText())) continue;
            placeNameService.setEnabled(!placeNameService.isEnabled());
            break;
        }
        this.update();
    }

    private void update() {
        this.wwd.redraw();
    }
}

