/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import gov.nasa.worldwindx.examples.util.DirectedPath;
import java.util.ArrayList;

public class PathsWithDirection
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialLatitude", 49.06);
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialLongitude", -122.77);
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialAltitude", 22000);
        ApplicationTemplate.start("World Wind Paths With Direction", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            super(true, true, false);
            RenderableLayer renderableLayer = new RenderableLayer();
            BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setOutlineMaterial(Material.RED);
            basicShapeAttributes.setOutlineWidth(2.0);
            ArrayList<Position> arrayList = new ArrayList<Position>();
            arrayList.add(Position.fromDegrees(49.01653274909177, -122.7349081128505, 1.0));
            arrayList.add(Position.fromDegrees(49.01715024535254, -122.7596194200486, 10.0));
            arrayList.add(Position.fromDegrees(49.02781845803761, -122.7651733463364, 100.0));
            arrayList.add(Position.fromDegrees(49.05312411976134, -122.7926787136435, 1000.0));
            arrayList.add(Position.fromDegrees(49.0747697644625, -122.8224152286015, 1000.0));
            arrayList.add(Position.fromDegrees(49.09727187849899, -122.8187118695457, 1000.0));
            arrayList.add(Position.fromDegrees(49.1002974270654, -122.7348314826556, 100.0));
            arrayList.add(Position.fromDegrees(49.11190305133165, -122.7345541413842, 100.0));
            arrayList.add(Position.fromDegrees(49.11101764617014, -122.7455553490629, 10.0));
            arrayList.add(Position.fromDegrees(49.11509767012883, -122.7459193678911, 10.0));
            arrayList.add(Position.fromDegrees(49.11467371318521, -122.7563706291131, 10.0));
            DirectedPath directedPath = new DirectedPath(arrayList);
            directedPath.setAttributes(basicShapeAttributes);
            directedPath.setVisible(true);
            directedPath.setAltitudeMode(2);
            directedPath.setPathType("gov.nasa.worldwind.avkey.GreatCircle");
            renderableLayer.addRenderable(directedPath);
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), renderableLayer);
            this.getLayerPanel().update(this.getWwd());
        }
    }
}

