/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.View;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Polyline;
import gov.nasa.worldwind.render.SurfacePolyline;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;

public class LineBackground
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Line Backgrounds", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            super(true, true, false);
            try {
                BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
                basicShapeAttributes.setOutlineMaterial(new Material(Color.BLUE));
                basicShapeAttributes.setOutlineStipplePattern((short)-21846);
                basicShapeAttributes.setOutlineStippleFactor(8);
                BasicShapeAttributes basicShapeAttributes2 = new BasicShapeAttributes();
                basicShapeAttributes2.setOutlineMaterial(new Material(Color.WHITE));
                basicShapeAttributes2.setOutlineOpacity(0.1);
                basicShapeAttributes2.setOutlineWidth(basicShapeAttributes.getOutlineWidth() + 2.0);
                SurfacePolyline surfacePolyline = new SurfacePolyline(new ArrayList<LatLon>(Arrays.asList(LatLon.fromDegrees(33.7, 119.6), LatLon.fromDegrees(33.5, 125.0), LatLon.fromDegrees(35.1, 129.1), LatLon.fromDegrees(35.8, 127.1))));
                surfacePolyline.setClosed(true);
                surfacePolyline.setAttributes(basicShapeAttributes);
                SurfacePolyline surfacePolyline2 = new SurfacePolyline(surfacePolyline.getLocations());
                surfacePolyline2.setClosed(true);
                surfacePolyline2.setAttributes(basicShapeAttributes2);
                ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
                for (LatLon object2 : surfacePolyline.getLocations()) {
                    arrayList.add(object2.add(LatLon.fromDegrees(2.0, 0.0)));
                }
                Polyline polyline = new Polyline(arrayList, 0.0);
                polyline.setFollowTerrain(true);
                polyline.setClosed(true);
                polyline.setPathType(2);
                polyline.setColor(basicShapeAttributes.getOutlineMaterial().getDiffuse());
                polyline.setLineWidth(basicShapeAttributes.getOutlineWidth());
                polyline.setStipplePattern(basicShapeAttributes.getOutlineStipplePattern());
                polyline.setStippleFactor(basicShapeAttributes.getOutlineStippleFactor());
                Polyline polyline2 = new Polyline(arrayList, 0.0);
                polyline2.setFollowTerrain(true);
                polyline2.setClosed(true);
                polyline2.setPathType(2);
                float[] fArray = basicShapeAttributes2.getOutlineMaterial().getDiffuse().getColorComponents(new float[3]);
                polyline2.setColor(new Color(fArray[0], fArray[1], fArray[2], (float)basicShapeAttributes2.getOutlineOpacity()));
                polyline2.setLineWidth(basicShapeAttributes2.getOutlineWidth());
                polyline2.setStipplePattern(basicShapeAttributes2.getOutlineStipplePattern());
                polyline2.setStippleFactor(basicShapeAttributes2.getOutlineStippleFactor());
                RenderableLayer renderableLayer = new RenderableLayer();
                renderableLayer.setName("Lines");
                renderableLayer.setPickEnabled(false);
                renderableLayer.addRenderable(surfacePolyline2);
                renderableLayer.addRenderable(surfacePolyline);
                renderableLayer.addRenderable(polyline);
                renderableLayer.addRenderable(polyline2);
                ApplicationTemplate.insertBeforeCompass(this.getWwd(), renderableLayer);
                this.getLayerPanel().update(this.getWwd());
                View view = this.getWwd().getView();
                view.setEyePosition(Position.fromDegrees(35.3, 124.6, 1500000.0));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

