/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.globes.EarthFlat;
import gov.nasa.worldwind.layers.IconLayer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.layers.SkyColorLayer;
import gov.nasa.worldwind.layers.SkyGradientLayer;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.pick.PickedObjectList;
import gov.nasa.worldwind.render.UserFacingIcon;
import gov.nasa.worldwind.view.orbit.FlatOrbitView;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import gov.nasa.worldwindx.examples.FlatWorldPanel;
import java.awt.Component;
import java.awt.Dimension;

public class IconPicking
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        Configuration.setValue("gov.nasa.worldwind.avkey.GlobeClassName", EarthFlat.class.getName());
        Configuration.setValue("gov.nasa.worldwind.avkey.ViewClassName", FlatOrbitView.class.getName());
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialAltitude", 2.7E7);
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialLatitude", 0);
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialLongitude", 88);
        ApplicationTemplate.start("World Wind Flat World", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            super(true, true, false);
            IconLayer iconLayer = new IconLayer();
            iconLayer.setPickEnabled(true);
            iconLayer.setAllowBatchPicking(false);
            iconLayer.setRegionCulling(true);
            UserFacingIcon userFacingIcon = new UserFacingIcon("src/images/32x32-icon-nasa.png", new Position(Angle.fromRadians(0.0), Angle.fromRadians(0.0), 0.0));
            userFacingIcon.setSize(new Dimension(24, 24));
            iconLayer.addIcon(userFacingIcon);
            userFacingIcon = new UserFacingIcon("src/images/32x32-icon-nasa.png", new Position(Angle.fromRadians(0.1), Angle.fromRadians(0.0), 0.0));
            userFacingIcon.setSize(new Dimension(24, 24));
            iconLayer.addIcon(userFacingIcon);
            userFacingIcon = new UserFacingIcon("src/images/32x32-icon-nasa.png", new Position(Angle.fromRadians(0.0), Angle.fromRadians(0.1), 0.0));
            userFacingIcon.setSize(new Dimension(24, 24));
            iconLayer.addIcon(userFacingIcon);
            userFacingIcon = new UserFacingIcon("src/images/32x32-icon-nasa.png", new Position(Angle.fromRadians(0.1), Angle.fromRadians(0.1), 0.0));
            userFacingIcon.setSize(new Dimension(24, 24));
            iconLayer.addIcon(userFacingIcon);
            userFacingIcon = new UserFacingIcon("src/images/32x32-icon-nasa.png", new Position(Angle.fromRadians(0.0), Angle.fromDegrees(180.0), 0.0));
            userFacingIcon.setSize(new Dimension(24, 24));
            iconLayer.addIcon(userFacingIcon);
            ApplicationTemplate.insertAfterPlacenames(this.getWwd(), iconLayer);
            LayerList layerList = this.getWwd().getModel().getLayers();
            for (int i = 0; i < layerList.size(); ++i) {
                if (!(layerList.get(i) instanceof SkyGradientLayer)) continue;
                layerList.set(i, new SkyColorLayer());
            }
            this.getLayerPanel().update(this.getWwd());
            this.getWwd().addSelectListener(new SelectListener(){

                @Override
                public void selected(SelectEvent selectEvent) {
                    if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Rollover")) {
                        PickedObjectList pickedObjectList = selectEvent.getObjects();
                        System.out.println(" Picked Objects Size " + pickedObjectList.size());
                        for (PickedObject pickedObject : pickedObjectList) {
                            System.out.println(" Class " + pickedObject.getObject().getClass().getName() + "  isTerrian=" + pickedObject.isTerrain());
                        }
                    }
                }
            });
            this.getWwd().getSceneController().setDeepPickEnabled(true);
            this.getLayerPanel().add((Component)new FlatWorldPanel(this.getWwd()), "South");
        }
    }
}

