/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.exception.NoItemException;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.poi.BasicPointOfInterest;
import gov.nasa.worldwind.poi.Gazetteer;
import gov.nasa.worldwind.poi.PointOfInterest;
import gov.nasa.worldwind.poi.YahooGazetteer;
import gov.nasa.worldwind.view.orbit.OrbitView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.xml.sax.SAXException;

public class GazetteerPanel
extends JPanel {
    private final WorldWindow wwd;
    private Gazetteer gazeteer;
    private JPanel resultsPanel;
    private JComboBox resultsBox;

    public GazetteerPanel(WorldWindow worldWindow, String string) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        super(new BorderLayout());
        this.gazeteer = string != null ? this.constructGazetteer(string) : new YahooGazetteer();
        this.wwd = worldWindow;
        URL uRL = this.getClass().getResource("/images/32x32-icon-earth.png");
        ImageIcon imageIcon = new ImageIcon(uRL);
        JLabel jLabel = new JLabel(imageIcon);
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 15, 0, 15));
        final JTextField jTextField = new JTextField("Name or Lat,Lon?");
        jTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(final ActionEvent actionEvent) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            GazetteerPanel.this.handleEntryAction(actionEvent);
                        }
                        catch (NoItemException noItemException) {
                            JOptionPane.showMessageDialog(GazetteerPanel.this, "Location not available \"" + (jTextField.getText() != null ? jTextField.getText() : "") + "\"\n" + "(" + noItemException.getMessage() + ")", "Location Not Available", 0);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            JOptionPane.showMessageDialog(GazetteerPanel.this, "Error parsing input \"" + (jTextField.getText() != null ? jTextField.getText() : "") + "\"\n" + illegalArgumentException.getMessage(), "Lookup Failure", 0);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            JOptionPane.showMessageDialog(GazetteerPanel.this, "Error looking up \"" + (jTextField.getText() != null ? jTextField.getText() : "") + "\"\n" + exception.getMessage(), "Lookup Failure", 0);
                        }
                    }
                });
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jTextField, "Center");
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 15));
        this.add((Component)jLabel, "West");
        this.add((Component)jPanel, "Center");
        this.resultsPanel = new JPanel(new GridLayout(1, 2));
        this.resultsPanel.add(new JLabel("Results: "));
        this.resultsBox = new JComboBox();
        this.resultsBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(final ActionEvent actionEvent) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                        PointOfInterest pointOfInterest = (PointOfInterest)jComboBox.getSelectedItem();
                        GazetteerPanel.this.moveToLocation(pointOfInterest);
                    }
                });
            }
        });
        this.resultsPanel.add(this.resultsBox);
        this.resultsPanel.setVisible(false);
        this.add((Component)this.resultsPanel, "East");
    }

    private Gazetteer constructGazetteer(String string) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Gazetteer class name is null");
        }
        Class<?> clazz = Class.forName(string.trim());
        Object obj = clazz.newInstance();
        if (!(obj instanceof Gazetteer)) {
            throw new IllegalArgumentException("Gazetteer class name is null");
        }
        return (Gazetteer)obj;
    }

    private void handleEntryAction(ActionEvent actionEvent) throws IOException, ParserConfigurationException, XPathExpressionException, SAXException, NoItemException, IllegalArgumentException {
        String string = null;
        this.resultsPanel.setVisible(false);
        if (actionEvent.getSource() instanceof JTextComponent) {
            string = ((JTextComponent)actionEvent.getSource()).getText();
        }
        if (string == null || string.length() < 1) {
            return;
        }
        List<PointOfInterest> list = this.parseSearchValues(string);
        if (list != null) {
            if (list.size() == 1) {
                this.moveToLocation(list.get(0));
            } else {
                this.resultsBox.removeAllItems();
                for (PointOfInterest pointOfInterest : list) {
                    this.resultsBox.addItem(pointOfInterest);
                }
                this.resultsPanel.setVisible(true);
            }
        }
    }

    private List<PointOfInterest> parseSearchValues(String string) {
        String string2 = "[,]";
        String[] stringArray = (string = string.trim()).split(string2);
        if (stringArray.length == 1) {
            return this.queryService(stringArray[0].trim());
        }
        if (stringArray.length == 2) {
            String string3 = "[0-9]";
            Pattern pattern = Pattern.compile(string3);
            Matcher matcher = pattern.matcher(stringArray[1]);
            if (matcher.find()) {
                ArrayList<PointOfInterest> arrayList = new ArrayList<PointOfInterest>();
                arrayList.add(this.parseCoordinates(stringArray));
                return arrayList;
            }
            return this.queryService(stringArray[0].trim() + "+" + stringArray[1].trim());
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i].trim());
            if (i >= stringArray.length - 1) continue;
            stringBuilder.append("+");
        }
        return this.queryService(stringBuilder.toString());
    }

    private List<PointOfInterest> queryService(String string) {
        List<PointOfInterest> list = this.gazeteer.findPlaces(string);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list;
    }

    private PointOfInterest parseCoordinates(String[] stringArray) {
        if (this.isDecimalDegrees(stringArray)) {
            Double d = Double.parseDouble(stringArray[0].trim());
            Double d2 = Double.parseDouble(stringArray[1].trim());
            return new BasicPointOfInterest(LatLon.fromDegrees(d, d2));
        }
        Angle angle = Angle.fromDMS(stringArray[0].trim());
        Angle angle2 = Angle.fromDMS(stringArray[1].trim());
        return new BasicPointOfInterest(LatLon.fromDegrees(angle.getDegrees(), angle2.getDegrees()));
    }

    private boolean isDecimalDegrees(String[] stringArray) {
        try {
            Double.parseDouble(stringArray[0].trim());
            Double.parseDouble(stringArray[1].trim());
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public void moveToLocation(PointOfInterest pointOfInterest) {
        this.wwd.getView().goTo(new Position(pointOfInterest.getLatlon(), 0.0), 25000.0);
    }

    public void moveToLocation(Sector sector, Double d) {
        OrbitView orbitView = (OrbitView)this.wwd.getView();
        Globe globe = this.wwd.getModel().getGlobe();
        if (d == null || d == 0.0) {
            double d2 = sector.getDeltaLonRadians() > sector.getDeltaLonRadians() ? sector.getDeltaLonRadians() : sector.getDeltaLonRadians();
            double d3 = 0.5 * d2 * 6378137.0;
            d = d3 / this.wwd.getView().getFieldOfView().tanHalfAngle();
        }
        if (globe != null && orbitView != null) {
            this.wwd.getView().goTo(new Position(sector.getCentroid(), 0.0), d);
        }
    }
}

