/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.util.Logging;

public class ClickAndGoSelectListener
implements SelectListener {
    private final WorldWindow wwd;
    private final Class pickedObjClass;
    private final double elevationOffset;

    public ClickAndGoSelectListener(WorldWindow worldWindow, Class clazz) {
        if (worldWindow == null) {
            String string = Logging.getMessage("nullValue.WorldWindow");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.wwd = worldWindow;
        this.pickedObjClass = clazz;
        this.elevationOffset = 0.0;
    }

    public ClickAndGoSelectListener(WorldWindow worldWindow, Class clazz, double d) {
        if (worldWindow == null) {
            String string = Logging.getMessage("nullValue.WorldWindow");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (clazz == null) {
            String string = Logging.getMessage("nullValue.ClassIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.wwd = worldWindow;
        this.pickedObjClass = clazz;
        this.elevationOffset = d;
    }

    @Override
    public void selected(SelectEvent selectEvent) {
        if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.LeftClick") && selectEvent.hasObjects() && selectEvent.getTopPickedObject().hasPosition() && selectEvent.getTopObject().getClass().equals(this.pickedObjClass)) {
            Position position = selectEvent.getTopPickedObject().getPosition();
            View view = this.wwd.getView();
            if (view != null) {
                view.goTo(new Position(position, 0.0), position.getElevation() + this.elevationOffset);
            }
        }
    }
}

