/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.cache.BasicDataFileStore;
import gov.nasa.worldwind.event.BulkRetrievalEvent;
import gov.nasa.worldwind.event.BulkRetrievalListener;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.ElevationModel;
import gov.nasa.worldwind.retrieve.BulkRetrievable;
import gov.nasa.worldwind.retrieve.BulkRetrievalThread;
import gov.nasa.worldwind.retrieve.Progress;
import gov.nasa.worldwind.terrain.CompoundElevationModel;
import gov.nasa.worldwindx.examples.util.SectorSelector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;

public class BulkDownloadPanel
extends JPanel {
    protected WorldWindow wwd;
    protected Sector currentSector;
    protected ArrayList<BulkRetrievablePanel> retrievables;
    protected JButton selectButton;
    protected JLabel sectorLabel;
    protected JButton startButton;
    protected JPanel monitorPanel;
    protected BasicDataFileStore cache;
    protected SectorSelector selector;

    public BulkDownloadPanel(WorldWindow worldWindow) {
        this.wwd = worldWindow;
        this.retrievables = new ArrayList();
        for (Object object : this.wwd.getModel().getLayers()) {
            if (!(object instanceof BulkRetrievable)) continue;
            this.retrievables.add(new BulkRetrievablePanel((BulkRetrievable)object));
        }
        CompoundElevationModel compoundElevationModel = (CompoundElevationModel)worldWindow.getModel().getGlobe().getElevationModel();
        for (ElevationModel elevationModel : compoundElevationModel.getElevationModels()) {
            if (!(elevationModel instanceof BulkRetrievable)) continue;
            this.retrievables.add(new BulkRetrievablePanel((BulkRetrievable)((Object)elevationModel)));
        }
        this.selector = new SectorSelector(worldWindow);
        this.selector.setInteriorColor(new Color(1.0f, 1.0f, 1.0f, 0.1f));
        this.selector.setBorderColor(new Color(1.0f, 0.0f, 0.0f, 0.5f));
        this.selector.setBorderWidth(3.0);
        this.selector.addPropertyChangeListener("gov.nasa.worldwind.SectorSelector", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                BulkDownloadPanel.this.updateSector();
            }
        });
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        this.initComponents();
    }

    protected void updateSector() {
        this.currentSector = this.selector.getSector();
        if (this.currentSector != null) {
            this.sectorLabel.setText(BulkDownloadPanel.makeSectorDescription(this.currentSector));
            this.selectButton.setText("Clear sector");
            this.startButton.setEnabled(true);
        } else {
            this.sectorLabel.setText("-");
            this.selectButton.setText("Select sector");
            this.startButton.setEnabled(false);
        }
        this.updateRetrievablePanels(this.currentSector);
    }

    protected void updateRetrievablePanels(Sector sector) {
        for (BulkRetrievablePanel bulkRetrievablePanel : this.retrievables) {
            bulkRetrievablePanel.updateDescription(sector);
        }
    }

    protected void selectButtonActionPerformed(ActionEvent actionEvent) {
        if (this.selector.getSector() != null) {
            this.selector.disable();
        } else {
            this.selector.enable();
        }
        this.updateSector();
    }

    public void clearSector() {
        if (this.selector.getSector() != null) {
            this.selector.disable();
        }
        this.updateSector();
    }

    protected void startButtonActionPerformed(ActionEvent actionEvent) {
        for (BulkRetrievablePanel bulkRetrievablePanel : this.retrievables) {
            BulkRetrievable bulkRetrievable;
            BulkRetrievalThread bulkRetrievalThread;
            if (!bulkRetrievablePanel.selectCheckBox.isSelected() || (bulkRetrievalThread = (bulkRetrievable = bulkRetrievablePanel.retrievable).makeLocal(this.currentSector, 0.0, this.cache, new BulkRetrievalListener(){

                @Override
                public void eventOccurred(BulkRetrievalEvent bulkRetrievalEvent) {
                }
            })) == null) continue;
            this.monitorPanel.add(new DownloadMonitorPanel(bulkRetrievalThread));
        }
        this.getTopLevelAncestor().validate();
    }

    public boolean hasActiveDownloads() {
        for (Component component : this.monitorPanel.getComponents()) {
            if (!(component instanceof DownloadMonitorPanel) || !((DownloadMonitorPanel)component).thread.isAlive()) continue;
            return true;
        }
        return false;
    }

    public void cancelActiveDownloads() {
        for (Component component : this.monitorPanel.getComponents()) {
            if (!(component instanceof DownloadMonitorPanel) || !((DownloadMonitorPanel)component).thread.isAlive()) continue;
            DownloadMonitorPanel downloadMonitorPanel = (DownloadMonitorPanel)component;
            downloadMonitorPanel.cancelButtonActionPerformed(null);
            try {
                long l = System.currentTimeMillis();
                while (downloadMonitorPanel.thread.isAlive() && System.currentTimeMillis() - l < 500L) {
                    Thread.sleep(10L);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void clearInactiveDownloads() {
        for (int i = this.monitorPanel.getComponentCount() - 1; i >= 0; --i) {
            Component component = this.monitorPanel.getComponents()[i];
            if (!(component instanceof DownloadMonitorPanel)) continue;
            DownloadMonitorPanel downloadMonitorPanel = (DownloadMonitorPanel)component;
            if (downloadMonitorPanel.thread.isAlive() && !downloadMonitorPanel.thread.isInterrupted()) continue;
            this.monitorPanel.remove(i);
        }
        this.monitorPanel.validate();
    }

    protected void initComponents() {
        int n = 6;
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder("Download")));
        this.setToolTipText("Layer imagery bulk download.");
        final JPanel jPanel2 = new JPanel(new BorderLayout(5, 5));
        JLabel jLabel = new JLabel(" Cache:");
        final JLabel jLabel2 = new JLabel("");
        JButton jButton = new JButton("...");
        jPanel2.add((Component)jLabel, "West");
        jPanel2.add((Component)jLabel2, "Center");
        jPanel2.add((Component)jButton, "East");
        this.add(jPanel2);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file;
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setFileSelectionMode(1);
                jFileChooser.setMultiSelectionEnabled(false);
                int n = jFileChooser.showOpenDialog(jPanel2);
                if (n == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                    jLabel2.setText(file.getPath());
                    BulkDownloadPanel.this.cache = new BasicDataFileStore(file);
                    BulkDownloadPanel.this.updateRetrievablePanels(BulkDownloadPanel.this.selector.getSector());
                }
            }
        });
        JPanel jPanel3 = new JPanel(new GridLayout(0, 1, 0, 0));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(n, n, n, n));
        this.selectButton = new JButton("Select sector");
        this.selectButton.setToolTipText("Press Select then press and drag button 1 on globe");
        this.selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BulkDownloadPanel.this.selectButtonActionPerformed(actionEvent);
            }
        });
        jPanel3.add(this.selectButton);
        this.sectorLabel = new JLabel("-");
        this.sectorLabel.setPreferredSize(new Dimension(350, 16));
        this.sectorLabel.setHorizontalAlignment(0);
        jPanel3.add(this.sectorLabel);
        this.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.setBorder(BorderFactory.createEmptyBorder(n, n, n, n));
        for (BulkRetrievablePanel jPanel5 : this.retrievables) {
            jPanel4.add(jPanel5);
        }
        this.add(jPanel4);
        JPanel jPanel6 = new JPanel(new GridLayout(0, 1, 0, 0));
        jPanel6.setBorder(BorderFactory.createEmptyBorder(n, n, n, n));
        this.startButton = new JButton("Start download");
        this.startButton.setEnabled(false);
        this.startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BulkDownloadPanel.this.startButtonActionPerformed(actionEvent);
            }
        });
        jPanel6.add(this.startButton);
        this.add(jPanel6);
        this.monitorPanel = new JPanel();
        this.monitorPanel.setLayout(new BoxLayout(this.monitorPanel, 1));
        this.monitorPanel.setBorder(BorderFactory.createEmptyBorder(n, n, n, n));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.monitorPanel, "North");
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jScrollPane.setPreferredSize(new Dimension(350, 200));
        this.add(jScrollPane);
    }

    public static String makeSectorDescription(Sector sector) {
        return String.format("S %7.4f\u00b0 W %7.4f\u00b0 N %7.4f\u00b0 E %7.4f\u00b0", sector.getMinLatitude().degrees, sector.getMinLongitude().degrees, sector.getMaxLatitude().degrees, sector.getMaxLongitude().degrees);
    }

    public static String makeSizeDescription(long l) {
        double d = l / 1024L / 1024L;
        if (d < 1024.0) {
            return String.format("%,.1f MB", d);
        }
        if (d < 1048576.0) {
            return String.format("%,.1f GB", d / 1024.0);
        }
        return String.format("%,.1f TB", d / 1024.0 / 1024.0);
    }

    public class DownloadMonitorPanel
    extends JPanel {
        protected BulkRetrievalThread thread;
        protected Progress progress;
        protected Timer updateTimer;
        protected JLabel descriptionLabel;
        protected JProgressBar progressBar;
        protected JButton cancelButton;

        public DownloadMonitorPanel(BulkRetrievalThread bulkRetrievalThread) {
            this.thread = bulkRetrievalThread;
            this.progress = bulkRetrievalThread.getProgress();
            this.initComponents();
            this.updateTimer = new Timer(1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DownloadMonitorPanel.this.updateStatus();
                }
            });
            this.updateTimer.start();
        }

        protected void updateStatus() {
            String string = this.thread.getRetrievable().getName();
            string = string.length() > 30 ? string.substring(0, 27) + "..." : string;
            string = string + " (" + BulkDownloadPanel.makeSizeDescription(this.progress.getCurrentSize()) + " / " + BulkDownloadPanel.makeSizeDescription(this.progress.getTotalSize()) + ")";
            this.descriptionLabel.setText(string);
            int n = 0;
            if (this.progress.getTotalCount() > 0L) {
                n = (int)((float)this.progress.getCurrentCount() / (float)this.progress.getTotalCount() * 100.0f);
            }
            this.progressBar.setValue(Math.min(n, 100));
            String string2 = BulkDownloadPanel.makeSectorDescription(this.thread.getSector());
            this.descriptionLabel.setToolTipText(string2);
            this.progressBar.setToolTipText(this.makeProgressDescription());
            if (!this.thread.isAlive()) {
                this.cancelButton.setText("Remove");
                this.cancelButton.setBackground(Color.GREEN);
                this.updateTimer.stop();
            }
        }

        protected void cancelButtonActionPerformed(ActionEvent actionEvent) {
            if (this.thread.isAlive()) {
                this.thread.interrupt();
                this.cancelButton.setBackground(Color.ORANGE);
                this.cancelButton.setText("Remove");
                this.updateTimer.stop();
            } else {
                Container container = this.getTopLevelAncestor();
                this.getParent().remove(this);
                container.validate();
            }
        }

        protected void initComponents() {
            int n = 2;
            this.setLayout(new BoxLayout(this, 1));
            this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel.setBorder(BorderFactory.createEmptyBorder(n, n, n, n));
            String string = this.thread.getRetrievable().getName();
            string = string.length() > 40 ? string.substring(0, 37) + "..." : string;
            this.descriptionLabel = new JLabel(string);
            jPanel.add(this.descriptionLabel);
            this.add(jPanel);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jPanel2.setBorder(BorderFactory.createEmptyBorder(n, n, n, n));
            this.progressBar = new JProgressBar(0, 100);
            this.progressBar.setPreferredSize(new Dimension(100, 16));
            jPanel2.add(this.progressBar);
            jPanel2.add(Box.createHorizontalStrut(8));
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.setBackground(Color.RED);
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DownloadMonitorPanel.this.cancelButtonActionPerformed(actionEvent);
                }
            });
            jPanel2.add(this.cancelButton);
            this.add(jPanel2);
        }

        protected String makeProgressDescription() {
            String string = "";
            if (this.progress.getTotalCount() > 0L) {
                int n = (int)((double)this.progress.getCurrentCount() / (double)this.progress.getTotalCount() * 100.0);
                string = n + "% of ";
                string = string + BulkDownloadPanel.makeSizeDescription(this.progress.getTotalSize());
            }
            return string;
        }
    }

    public class BulkRetrievablePanel
    extends JPanel {
        protected BulkRetrievable retrievable;
        protected JCheckBox selectCheckBox;
        protected JLabel descriptionLabel;
        protected Thread updateThread;
        protected Sector sector;

        BulkRetrievablePanel(BulkRetrievable bulkRetrievable) {
            this.retrievable = bulkRetrievable;
            this.initComponents();
        }

        protected void initComponents() {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.selectCheckBox = new JCheckBox(this.retrievable.getName());
            this.selectCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (((JCheckBox)actionEvent.getSource()).isSelected() && BulkRetrievablePanel.this.sector != null) {
                        BulkRetrievablePanel.this.updateDescription(BulkRetrievablePanel.this.sector);
                    }
                }
            });
            this.add((Component)this.selectCheckBox, "West");
            this.descriptionLabel = new JLabel();
            this.add((Component)this.descriptionLabel, "East");
        }

        public void updateDescription(final Sector sector) {
            if (this.updateThread != null && this.updateThread.isAlive()) {
                return;
            }
            this.sector = sector;
            if (!this.selectCheckBox.isSelected()) {
                this.doUpdateDescription(null);
                return;
            }
            this.updateThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    BulkRetrievablePanel.this.doUpdateDescription(sector);
                }
            });
            this.updateThread.setDaemon(true);
            this.updateThread.start();
        }

        protected void doUpdateDescription(Sector sector) {
            if (sector != null) {
                try {
                    long l = this.retrievable.getEstimatedMissingDataSize(sector, 0.0, BulkDownloadPanel.this.cache);
                    final String string = BulkDownloadPanel.makeSizeDescription(l);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            BulkRetrievablePanel.this.descriptionLabel.setText(string);
                        }
                    });
                }
                catch (Exception exception) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            BulkRetrievablePanel.this.descriptionLabel.setText("-");
                        }
                    });
                }
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BulkRetrievablePanel.this.descriptionLabel.setText("-");
                    }
                });
            }
        }

        @Override
        public String toString() {
            return this.retrievable.getName();
        }
    }
}

